/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;

@Internal
public final class RowMessages {
    private RowMessages() {
    }

    public static <T> SimpleFunction<byte[], Row> bytesToRowFn(SchemaProvider schemaProvider, TypeDescriptor<T> typeDescriptor, ProcessFunction<byte[], ? extends T> fromBytesFn) {
        SerializableFunction<T, Row> toRowFn = Preconditions.checkArgumentNotNull(schemaProvider.toRowFunction(typeDescriptor));
        return new BytesToRowFn(fromBytesFn, toRowFn);
    }

    public static <T> SimpleFunction<byte[], Row> bytesToRowFn(SchemaProvider schemaProvider, TypeDescriptor<T> typeDescriptor, Coder<? extends T> coder) {
        return RowMessages.bytesToRowFn(schemaProvider, typeDescriptor, (byte[] bytes) -> coder.decode(new ByteArrayInputStream((byte[])bytes)));
    }

    public static <T> SimpleFunction<Row, byte[]> rowToBytesFn(SchemaProvider schemaProvider, TypeDescriptor<T> typeDescriptor, ProcessFunction<? super T, byte[]> toBytesFn) {
        Schema schema = Preconditions.checkArgumentNotNull(schemaProvider.schemaFor(typeDescriptor));
        SerializableFunction<Row, T> fromRowFn = Preconditions.checkArgumentNotNull(schemaProvider.fromRowFunction(typeDescriptor));
        toBytesFn = Preconditions.checkArgumentNotNull(toBytesFn);
        return new RowToBytesFn(schema, fromRowFn, toBytesFn);
    }

    public static <T> SimpleFunction<Row, byte[]> rowToBytesFn(SchemaProvider schemaProvider, TypeDescriptor<T> typeDescriptor, Coder<? super T> coder) {
        return RowMessages.rowToBytesFn(schemaProvider, typeDescriptor, (? super T message) -> RowMessages.toBytes(coder, message));
    }

    private static <T> byte[] toBytes(Coder<? super T> coder, T message) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        coder.encode(message, out);
        return out.toByteArray();
    }

    private static final class RowToBytesFn<T>
    extends SimpleFunction<Row, byte[]> {
        private final Schema schema;
        private final SerializableFunction<Row, T> fromRowFn;
        private final ProcessFunction<? super T, byte[]> toBytesFn;

        private RowToBytesFn(Schema schema, SerializableFunction<Row, T> fromRowFn, ProcessFunction<? super T, byte[]> toBytesFn) {
            this.schema = schema;
            this.fromRowFn = fromRowFn;
            this.toBytesFn = toBytesFn;
        }

        @Override
        public byte[] apply(Row row) {
            if (!this.schema.equivalent(row.getSchema())) {
                row = this.switchFieldsOrder(row);
            }
            T message = this.fromRowFn.apply(row);
            try {
                return this.toBytesFn.apply(message);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not encode message as bytes", e);
            }
        }

        private Row switchFieldsOrder(Row row) {
            Row.Builder convertedRow = Row.withSchema(this.schema);
            this.schema.getFields().forEach(field -> convertedRow.addValue(row.getValue(field.getName())));
            return convertedRow.build();
        }
    }

    private static final class BytesToRowFn<T>
    extends SimpleFunction<byte[], Row> {
        private final ProcessFunction<byte[], ? extends T> fromBytesFn;
        private final SerializableFunction<T, Row> toRowFn;

        private BytesToRowFn(ProcessFunction<byte[], ? extends T> fromBytesFn, SerializableFunction<T, Row> toRowFn) {
            this.fromBytesFn = fromBytesFn;
            this.toRowFn = toRowFn;
        }

        @Override
        public Row apply(byte[] bytes) {
            T message;
            try {
                message = this.fromBytesFn.apply(bytes);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not decode bytes as message", e);
            }
            return this.toRowFn.apply(message);
        }
    }
}

