/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.bq;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.transform.BeamBQOutputTransform;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.Dummy;
import org.apache.hop.pipeline.transforms.dummy.DummyData;

@Transform(id="BeamBQOutput", image="beam-bq-output.svg", name="Beam BigQuery Output", description="Writes to a BigQuery table in Beam", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.BigData", documentationUrl="/pipeline/transforms/beambigqueryoutput.html", keywords={"i18n::BeamBQOutputDialog.keyword"})
public class BeamBQOutputMeta
extends BaseTransformMeta<Dummy, DummyData>
implements IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="project_id")
    private String projectId;
    @HopMetadataProperty(key="dataset_id")
    private String datasetId;
    @HopMetadataProperty(key="table_id")
    private String tableId;
    @HopMetadataProperty(key="create_if_needed")
    private boolean creatingIfNeeded;
    @HopMetadataProperty(key="truncate_table")
    private boolean truncatingTable;
    @HopMetadataProperty(key="fail_if_not_empty")
    private boolean failingIfNotEmpty;

    public void setDefault() {
        this.creatingIfNeeded = true;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        inputRowMeta.clear();
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return true;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        BeamBQOutputTransform beamOutputTransform = new BeamBQOutputTransform(transformMeta.getName(), variables.resolve(this.projectId), variables.resolve(this.datasetId), variables.resolve(this.tableId), this.creatingIfNeeded, this.truncatingTable, this.failingIfNotEmpty, JsonRowMeta.toJson((IRowMeta)rowMeta), transformPluginClasses, xpPluginClasses);
        if (previousTransforms.size() > 1) {
            throw new HopException("Combining data from multiple transforms is not supported yet!");
        }
        TransformMeta previousTransform = previousTransforms.get(0);
        input.apply((PTransform)beamOutputTransform);
        log.logBasic("Handled transform (BQ OUTPUT) : " + transformMeta.getName() + ", gets data from " + previousTransform.getName());
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public boolean isCreatingIfNeeded() {
        return this.creatingIfNeeded;
    }

    public void setCreatingIfNeeded(boolean creatingIfNeeded) {
        this.creatingIfNeeded = creatingIfNeeded;
    }

    public boolean isTruncatingTable() {
        return this.truncatingTable;
    }

    public void setTruncatingTable(boolean truncatingTable) {
        this.truncatingTable = truncatingTable;
    }

    public boolean isFailingIfNotEmpty() {
        return this.failingIfNotEmpty;
    }

    public void setFailingIfNotEmpty(boolean failingIfNotEmpty) {
        this.failingIfNotEmpty = failingIfNotEmpty;
    }
}

