/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ProgramMapEntry;
import com.ibm.as400.resource.ResourceLevel;
import com.ibm.as400.resource.ValueMap;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ProgramMap
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private Hashtable table_ = new Hashtable();
    private Object[] ids_ = null;
    private Vector idsV_ = new Vector();

    public void add(Object object, String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("dataName");
        }
        this.add(object, new ProgramMapEntry(string, string2, (int[])null, null, null));
    }

    public void add(Object object, String string, String string2, ValueMap valueMap) {
        if (string2 == null) {
            throw new NullPointerException("dataName");
        }
        this.add(object, new ProgramMapEntry(string, string2, (int[])null, valueMap, null));
    }

    public void add(Object object, String string, String string2, ValueMap valueMap, ResourceLevel resourceLevel) {
        if (string2 == null) {
            throw new NullPointerException("dataName");
        }
        this.add(object, new ProgramMapEntry(string, string2, (int[])null, valueMap, resourceLevel));
    }

    public void add(Object object, String string, String string2, int[] nArray) {
        if (string2 == null) {
            throw new NullPointerException("dataName");
        }
        this.add(object, new ProgramMapEntry(string, string2, nArray, null, null));
    }

    public void add(Object object, String string, String string2, String string3, ValueMap valueMap) {
        if (string2 == null) {
            throw new NullPointerException("dataName");
        }
        this.add(object, new ProgramMapEntry(string, string2, string3, valueMap, null));
    }

    public void add(Object object, String string, String string2, String string3) {
        if (string2 == null) {
            throw new NullPointerException("dataName");
        }
        this.add(object, new ProgramMapEntry(string, string2, string3, null, null));
    }

    public void add(Object object, String string, String string2, int[] nArray, ValueMap valueMap) {
        if (string2 == null) {
            throw new NullPointerException("dataName");
        }
        this.add(object, new ProgramMapEntry(string, string2, nArray, valueMap, null));
    }

    private synchronized void add(Object object, ProgramMapEntry programMapEntry) {
        Vector vector;
        if (object == null) {
            throw new NullPointerException("id");
        }
        if (programMapEntry == null) {
            throw new NullPointerException("entry");
        }
        if (this.table_.containsKey(object)) {
            vector = (Vector)this.table_.get(object);
        } else {
            vector = new Vector();
            this.table_.put(object, vector);
        }
        vector.addElement(programMapEntry);
        this.idsV_.addElement(object);
        this.ids_ = null;
    }

    ProgramMapEntry[] getEntries(Object object) {
        if (object == null) {
            throw new NullPointerException("id");
        }
        if (!this.table_.containsKey(object)) {
            throw new ExtendedIllegalArgumentException("id", 2);
        }
        Vector vector = (Vector)this.table_.get(object);
        Object[] objectArray = new ProgramMapEntry[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Object[] getIDs() {
        if (this.ids_ == null) {
            this.ids_ = new Object[this.idsV_.size()];
            this.idsV_.copyInto(this.ids_);
        }
        return this.ids_;
    }

    synchronized Object[] getIDs(String string) {
        Object object;
        Vector vector = new Vector(this.idsV_.size());
        Enumeration enumeration = this.idsV_.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Vector vector2 = (Vector)this.table_.get(object);
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                ProgramMapEntry programMapEntry = (ProgramMapEntry)enumeration2.nextElement();
                if (!programMapEntry.getLevel().checkLevel(string) || vector.contains(object)) continue;
                vector.addElement(object);
            }
        }
        object = new Object[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public Object[] getValues(Object[] objectArray, AS400 aS400, ProgramCallDocument programCallDocument, String string, int[] nArray) throws PcmlException {
        if (objectArray == null) {
            throw new NullPointerException("ids");
        }
        if (programCallDocument == null) {
            throw new NullPointerException("document");
        }
        int n = AS400BidiTransform.getStringType((char)aS400.getCcsid());
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.table_.containsKey(objectArray[i])) {
                throw new ExtendedIllegalArgumentException("ids[" + i + "]", 2);
            }
            Vector vector = (Vector)this.table_.get(objectArray[i]);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ProgramMapEntry programMapEntry = (ProgramMapEntry)enumeration.nextElement();
                String string2 = programMapEntry.getProgramName();
                if (string == null || string2 == null) {
                    objectArray2[i] = programMapEntry.getValue(aS400, programCallDocument, string, nArray, n);
                    break;
                }
                if (!string.equals(programMapEntry.getProgramName())) continue;
                objectArray2[i] = programMapEntry.getValue(aS400, programCallDocument, string, nArray, n);
                break;
            }
            if (objectArray2[i] != null) continue;
            throw new ExtendedIllegalArgumentException("values[" + i + "]", 2);
        }
        return objectArray2;
    }

    void setValues(Object[] objectArray, Object[] objectArray2, AS400 aS400, ProgramCallDocument programCallDocument, String string, int[] nArray, int[] nArray2) throws PcmlException {
        if (objectArray == null) {
            throw new NullPointerException("ids");
        }
        if (objectArray2 == null) {
            throw new NullPointerException("values");
        }
        if (objectArray.length != objectArray2.length) {
            throw new ExtendedIllegalArgumentException("values", 2);
        }
        if (objectArray.length != nArray2.length) {
            throw new ExtendedIllegalArgumentException("bidiStringTypes", 2);
        }
        if (programCallDocument == null) {
            throw new NullPointerException("document");
        }
        block0: for (int i = 0; i < objectArray.length; ++i) {
            if (!this.table_.containsKey(objectArray[i])) continue;
            Vector vector = (Vector)this.table_.get(objectArray[i]);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ProgramMapEntry programMapEntry = (ProgramMapEntry)enumeration.nextElement();
                String string2 = programMapEntry.getProgramName();
                if (string == null) {
                    programMapEntry.setValue(aS400, programCallDocument, string2, nArray, objectArray2[i], nArray2[i]);
                    continue block0;
                }
                if (string2 == null) {
                    programMapEntry.setValue(aS400, programCallDocument, string, nArray, objectArray2[i], nArray2[i]);
                    continue block0;
                }
                if (!string.equals(programMapEntry.getProgramName())) continue;
                programMapEntry.setValue(aS400, programCallDocument, string, nArray, objectArray2[i], nArray2[i]);
                continue block0;
            }
        }
    }
}

