/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Map;
import java.util.NavigableSet;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

class DirectTimerInternals
implements TimerInternals {
    private final Clock processingTimeClock;
    private final WatermarkManager.TransformWatermarks watermarks;
    private final WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder;
    private final Map<TimeDomain, NavigableSet<TimerInternals.TimerData>> modifiedTimers;
    private final Map<String, TimerInternals.TimerData> modifiedTimerIds;

    public static DirectTimerInternals create(Clock clock, WatermarkManager.TransformWatermarks watermarks, WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        return new DirectTimerInternals(clock, watermarks, timerUpdateBuilder);
    }

    private DirectTimerInternals(Clock clock, WatermarkManager.TransformWatermarks watermarks, WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        this.processingTimeClock = clock;
        this.watermarks = watermarks;
        this.timerUpdateBuilder = timerUpdateBuilder;
        this.modifiedTimers = Maps.newHashMap();
        this.modifiedTimers.put(TimeDomain.EVENT_TIME, Sets.newTreeSet());
        this.modifiedTimers.put(TimeDomain.PROCESSING_TIME, Sets.newTreeSet());
        this.modifiedTimers.put(TimeDomain.SYNCHRONIZED_PROCESSING_TIME, Sets.newTreeSet());
        this.modifiedTimerIds = Maps.newHashMap();
    }

    @Override
    public void setTimer(StateNamespace namespace, String timerId, String timerFamilyId, Instant target, Instant outputTimestamp, TimeDomain timeDomain) {
        this.setTimer(TimerInternals.TimerData.of(timerId, timerFamilyId, namespace, target, outputTimestamp, timeDomain));
    }

    @Override
    @Deprecated
    public void setTimer(TimerInternals.TimerData timerData) {
        this.timerUpdateBuilder.setTimer(timerData);
        this.getModifiedTimersOrdered(timerData.getDomain()).add(timerData);
        this.modifiedTimerIds.put(timerData.stringKey(), timerData);
    }

    @Override
    public void deleteTimer(StateNamespace namespace, String timerId, String timerFamilyId, TimeDomain timeDomain) {
        this.deleteTimer(TimerInternals.TimerData.of(timerId, timerFamilyId, namespace, BoundedWindow.TIMESTAMP_MIN_VALUE, BoundedWindow.TIMESTAMP_MAX_VALUE, timeDomain));
    }

    @Override
    @Deprecated
    public void deleteTimer(StateNamespace namespace, String timerId, String timerFamilyId) {
        throw new UnsupportedOperationException("Canceling of timer by ID is not yet supported.");
    }

    @Override
    @Deprecated
    public void deleteTimer(TimerInternals.TimerData timerData) {
        this.timerUpdateBuilder.deletedTimer(timerData);
        this.modifiedTimerIds.put(timerData.stringKey(), timerData.deleted());
    }

    public WatermarkManager.TimerUpdate getTimerUpdate() {
        return this.timerUpdateBuilder.build();
    }

    public NavigableSet<TimerInternals.TimerData> getModifiedTimersOrdered(TimeDomain timeDomain) {
        NavigableSet<TimerInternals.TimerData> modified = this.modifiedTimers.get((Object)timeDomain);
        if (modified == null) {
            throw new IllegalStateException("Unexpected time domain " + (Object)((Object)timeDomain));
        }
        return modified;
    }

    public Map<String, TimerInternals.TimerData> getModifiedTimerIds() {
        return this.modifiedTimerIds;
    }

    @Override
    public Instant currentProcessingTime() {
        return this.processingTimeClock.now();
    }

    @Override
    public @Nullable Instant currentSynchronizedProcessingTime() {
        return this.watermarks.getSynchronizedProcessingInputTime();
    }

    @Override
    public Instant currentInputWatermarkTime() {
        return this.watermarks.getInputWatermark();
    }

    @Override
    public @Nullable Instant currentOutputWatermarkTime() {
        return this.watermarks.getOutputWatermark();
    }
}

