/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui.plugin.toolbar;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.hop.core.gui.plugin.BaseGuiElements;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;

public class GuiToolbarItem
extends BaseGuiElements
implements Comparable<GuiToolbarItem> {
    private String root;
    private String id;
    private String label;
    private String toolTip;
    private GuiToolbarElementType type;
    private String image;
    private String disabledImage;
    private boolean password;
    private String getComboValuesMethod;
    private boolean ignored;
    private boolean addingSeparator;
    private ClassLoader classLoader;
    private boolean singleTon;
    private String listenerClass;
    private String listenerMethod;
    private int extraWidth;
    private boolean alignRight;

    public GuiToolbarItem() {
    }

    public GuiToolbarItem(GuiToolbarElement toolbarElement, String listenerClass, Method method, ClassLoader classLoader) {
        this();
        this.root = toolbarElement.root();
        this.id = toolbarElement.id();
        this.type = toolbarElement.type();
        this.getComboValuesMethod = toolbarElement.comboValuesMethod();
        this.image = toolbarElement.image();
        this.disabledImage = toolbarElement.disabledImage();
        this.password = toolbarElement.password();
        this.ignored = toolbarElement.ignored();
        this.addingSeparator = toolbarElement.separator();
        this.singleTon = true;
        this.listenerClass = listenerClass;
        this.listenerMethod = method.getName();
        this.label = this.getTranslation(toolbarElement.label(), method.getDeclaringClass().getPackage().getName(), method.getDeclaringClass());
        this.toolTip = this.getTranslation(toolbarElement.toolTip(), method.getDeclaringClass().getPackage().getName(), method.getDeclaringClass());
        this.classLoader = classLoader;
        this.extraWidth = toolbarElement.extraWidth();
        this.alignRight = toolbarElement.alignRight();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuiToolbarItem that = (GuiToolbarItem)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "GuiToolbarItem{id='" + this.id + "'}";
    }

    @Override
    public int compareTo(GuiToolbarItem o) {
        return this.id.compareTo(o.id);
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public GuiToolbarElementType getType() {
        return this.type;
    }

    public void setType(GuiToolbarElementType type) {
        this.type = type;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getDisabledImage() {
        return this.disabledImage;
    }

    public void setDisabledImage(String disabledImage) {
        this.disabledImage = disabledImage;
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public String getGetComboValuesMethod() {
        return this.getComboValuesMethod;
    }

    public void setGetComboValuesMethod(String getComboValuesMethod) {
        this.getComboValuesMethod = getComboValuesMethod;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean isAddingSeparator() {
        return this.addingSeparator;
    }

    public void setAddingSeparator(boolean addingSeparator) {
        this.addingSeparator = addingSeparator;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isSingleTon() {
        return this.singleTon;
    }

    public void setSingleTon(boolean singleTon) {
        this.singleTon = singleTon;
    }

    public String getListenerClass() {
        return this.listenerClass;
    }

    public void setListenerClass(String listenerClass) {
        this.listenerClass = listenerClass;
    }

    public String getListenerMethod() {
        return this.listenerMethod;
    }

    public void setListenerMethod(String listenerMethod) {
        this.listenerMethod = listenerMethod;
    }

    public int getExtraWidth() {
        return this.extraWidth;
    }

    public void setExtraWidth(int extraWidth) {
        this.extraWidth = extraWidth;
    }

    public boolean isAlignRight() {
        return this.alignRight;
    }

    public void setAlignRight(boolean alignRight) {
        this.alignRight = alignRight;
    }
}

