/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.graph;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.core.value.ValueMetaGraph;
import org.apache.hop.neo4j.transforms.graph.FieldModelMapping;
import org.apache.hop.neo4j.transforms.graph.GraphOutput;
import org.apache.hop.neo4j.transforms.graph.GraphOutputData;
import org.apache.hop.neo4j.transforms.graph.GraphOutputDialog;
import org.apache.hop.neo4j.transforms.graph.NodeMapping;
import org.apache.hop.neo4j.transforms.graph.RelationshipMapping;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="Neo4jGraphOutput", name="Neo4j Graph Output", description="Write to a Neo4j graph using an input field mapping", image="neo4j_graph_output.svg", categoryDescription="Neo4j", keywords={"i18n::GraphOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/neo4j-graphoutput.html")
public class GraphOutputMeta
extends BaseTransformMeta<GraphOutput, GraphOutputData> {
    @HopMetadataProperty(key="connection", injectionKey="connection", injectionKeyDescription="GraphOutput.Injection.CONNECTION")
    private String connectionName;
    @HopMetadataProperty(key="model", injectionKey="model", injectionKeyDescription="GraphOutput.Injection.MODEL")
    private String model;
    @HopMetadataProperty(key="batch_size", injectionKey="batch_size", injectionKeyDescription="GraphOutput.Injection.BATCH_SIZE")
    private String batchSize;
    @HopMetadataProperty(key="create_indexes", injectionKey="create_indexes", injectionKeyDescription="GraphOutput.Injection.CREATE_INDEXES")
    private boolean creatingIndexes = false;
    @HopMetadataProperty(key="returning_graph", injectionKey="returning_graph", injectionKeyDescription="GraphOutput.Injection.RETURNING_GRAPH")
    private boolean returningGraph;
    @HopMetadataProperty(key="return_graph_field", injectionKey="return_graph_field", injectionKeyDescription="GraphOutput.Injection.RETURNING_GRAPH_FIELD")
    private String returnGraphField;
    @HopMetadataProperty(key="validate_against_model", injectionKey="validate_against_model", injectionKeyDescription="GraphOutput.Injection.VALIDATE_AGAINST_MODEL")
    private boolean validatingAgainstModel;
    @HopMetadataProperty(key="out_of_order_allowed", injectionKey="out_of_order_allowed", injectionKeyDescription="GraphOutput.Injection.OUT_OF_ORDER_ALLOWED")
    private boolean outOfOrderAllowed = true;
    @HopMetadataProperty(groupKey="mappings", key="mapping", injectionGroupKey="mappings", injectionKey="mapping", injectionGroupDescription="GraphOutput.Injection.MAPPINGS", injectionKeyDescription="GraphOutput.Injection.MAPPING")
    private List<FieldModelMapping> fieldModelMappings = new ArrayList<FieldModelMapping>();
    @HopMetadataProperty(groupKey="relationship_mappings", key="relationship_mapping", injectionGroupKey="relationship_mappings", injectionGroupDescription="GraphOutput.Injection.RELATIONSHIP_MAPPINGS", injectionKeyDescription="GraphOutput.Injection.RELATIONSHIP_MAPPING")
    private List<RelationshipMapping> relationshipMappings = new ArrayList<RelationshipMapping>();
    @HopMetadataProperty(groupKey="node_mappings", key="node_mapping", injectionGroupKey="node_mappings", injectionGroupDescription="GraphOutput.Injection.NODE_MAPPINGS", injectionKeyDescription="GraphOutput.Injection.NODE_MAPPING")
    private List<NodeMapping> nodeMappings = new ArrayList<NodeMapping>();

    public String getDialogClassName() {
        return GraphOutputDialog.class.getName();
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextStep, IVariables space, IHopMetadataProvider metadataProvider) {
        if (this.returningGraph) {
            ValueMetaGraph valueMetaGraph = new ValueMetaGraph(Const.NVL((String)this.returnGraphField, (String)"graph"));
            valueMetaGraph.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)valueMetaGraph);
        }
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isCreatingIndexes() {
        return this.creatingIndexes;
    }

    public void setCreatingIndexes(boolean creatingIndexes) {
        this.creatingIndexes = creatingIndexes;
    }

    public List<FieldModelMapping> getFieldModelMappings() {
        return this.fieldModelMappings;
    }

    public void setFieldModelMappings(List<FieldModelMapping> fieldModelMappings) {
        this.fieldModelMappings = fieldModelMappings;
    }

    public boolean isReturningGraph() {
        return this.returningGraph;
    }

    public void setReturningGraph(boolean returningGraph) {
        this.returningGraph = returningGraph;
    }

    public String getReturnGraphField() {
        return this.returnGraphField;
    }

    public void setReturnGraphField(String returnGraphField) {
        this.returnGraphField = returnGraphField;
    }

    public boolean isValidatingAgainstModel() {
        return this.validatingAgainstModel;
    }

    public void setValidatingAgainstModel(boolean validatingAgainstModel) {
        this.validatingAgainstModel = validatingAgainstModel;
    }

    public boolean isOutOfOrderAllowed() {
        return this.outOfOrderAllowed;
    }

    public void setOutOfOrderAllowed(boolean outOfOrderAllowed) {
        this.outOfOrderAllowed = outOfOrderAllowed;
    }

    public List<RelationshipMapping> getRelationshipMappings() {
        return this.relationshipMappings;
    }

    public void setRelationshipMappings(List<RelationshipMapping> relationshipMappings) {
        this.relationshipMappings = relationshipMappings;
    }

    public List<NodeMapping> getNodeMappings() {
        return this.nodeMappings;
    }

    public void setNodeMappings(List<NodeMapping> nodeMappings) {
        this.nodeMappings = nodeMappings;
    }
}

