/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate.window;

import java.time.ZoneId;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.RecordsWindowBuffer;
import org.apache.flink.table.runtime.operators.deduplicate.window.combines.RowTimeDeduplicateRecordsCombiner;
import org.apache.flink.table.runtime.operators.deduplicate.window.processors.RowTimeWindowDeduplicateProcessor;
import org.apache.flink.table.runtime.operators.window.slicing.SlicingWindowOperator;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.util.Preconditions;

public class RowTimeWindowDeduplicateOperatorBuilder {
    private AbstractRowDataSerializer<RowData> inputSerializer;
    private PagedTypeSerializer<RowData> keySerializer;
    private int rowtimeIndex;
    private int windowEndIndex = -1;
    private ZoneId shiftTimeZone;
    private boolean keepLastRow;

    public static RowTimeWindowDeduplicateOperatorBuilder builder() {
        return new RowTimeWindowDeduplicateOperatorBuilder();
    }

    public RowTimeWindowDeduplicateOperatorBuilder inputSerializer(AbstractRowDataSerializer<RowData> inputSerializer) {
        this.inputSerializer = inputSerializer;
        return this;
    }

    public RowTimeWindowDeduplicateOperatorBuilder shiftTimeZone(ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        return this;
    }

    public RowTimeWindowDeduplicateOperatorBuilder keySerializer(PagedTypeSerializer<RowData> keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    public RowTimeWindowDeduplicateOperatorBuilder keepLastRow(boolean keepLastRow) {
        this.keepLastRow = keepLastRow;
        return this;
    }

    public RowTimeWindowDeduplicateOperatorBuilder rowtimeIndex(int rowtimeIndex) {
        this.rowtimeIndex = rowtimeIndex;
        return this;
    }

    public RowTimeWindowDeduplicateOperatorBuilder windowEndIndex(int windowEndIndex) {
        this.windowEndIndex = windowEndIndex;
        return this;
    }

    public SlicingWindowOperator<RowData, ?> build() {
        Preconditions.checkNotNull(this.inputSerializer);
        Preconditions.checkNotNull(this.keySerializer);
        Preconditions.checkArgument((this.windowEndIndex >= 0 ? 1 : 0) != 0, (Object)String.format("Illegal window end index %s, it should not be negative!", this.windowEndIndex));
        RowTimeDeduplicateRecordsCombiner.Factory combinerFactory = new RowTimeDeduplicateRecordsCombiner.Factory(this.inputSerializer, this.rowtimeIndex, this.keepLastRow);
        RecordsWindowBuffer.Factory bufferFactory = new RecordsWindowBuffer.Factory(this.keySerializer, this.inputSerializer, combinerFactory);
        RowTimeWindowDeduplicateProcessor windowProcessor = new RowTimeWindowDeduplicateProcessor(this.inputSerializer, bufferFactory, this.windowEndIndex, this.shiftTimeZone);
        return new SlicingWindowOperator(windowProcessor);
    }
}

