/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.examples.java.graph.util.EnumTrianglesData;
import org.apache.flink.examples.java.graph.util.EnumTrianglesDataTypes;
import org.apache.flink.util.Collector;

public class EnumTriangles {
    public static void main(String[] args) throws Exception {
        MapOperator edges;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        if (params.has("edges")) {
            edges = env.readCsvFile(params.get("edges")).fieldDelimiter(" ").includeFields(new boolean[]{true, true}).types(Integer.class, Integer.class).map((MapFunction)new TupleEdgeConverter());
        } else {
            System.out.println("Executing EnumTriangles example with default edges data set.");
            System.out.println("Use --edges to specify file input.");
            edges = EnumTrianglesData.getDefaultEdgeDataSet(env);
        }
        MapOperator edgesById = edges.map((MapFunction)new EdgeByIdProjector());
        JoinOperator.EquiJoin triangles = edgesById.groupBy(new int[]{0}).sortGroup(1, Order.ASCENDING).reduceGroup((GroupReduceFunction)new TriadBuilder()).join((DataSet)edgesById).where(new int[]{1, 2}).equalTo(new int[]{0, 1}).with((JoinFunction)new TriadFilter());
        if (params.has("output")) {
            triangles.writeAsCsv(params.get("output"), "\n", ",");
            env.execute("Basic Triangle Enumeration Example");
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            triangles.print();
        }
    }

    private static class TriadFilter
    implements JoinFunction<EnumTrianglesDataTypes.Triad, EnumTrianglesDataTypes.Edge, EnumTrianglesDataTypes.Triad> {
        private TriadFilter() {
        }

        public EnumTrianglesDataTypes.Triad join(EnumTrianglesDataTypes.Triad triad, EnumTrianglesDataTypes.Edge edge) throws Exception {
            return triad;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static class TriadBuilder
    implements GroupReduceFunction<EnumTrianglesDataTypes.Edge, EnumTrianglesDataTypes.Triad> {
        private final List<Integer> vertices = new ArrayList<Integer>();
        private final EnumTrianglesDataTypes.Triad outTriad = new EnumTrianglesDataTypes.Triad();

        private TriadBuilder() {
        }

        public void reduce(Iterable<EnumTrianglesDataTypes.Edge> edgesIter, Collector<EnumTrianglesDataTypes.Triad> out) throws Exception {
            Iterator<EnumTrianglesDataTypes.Edge> edges = edgesIter.iterator();
            this.vertices.clear();
            EnumTrianglesDataTypes.Edge firstEdge = edges.next();
            this.outTriad.setFirstVertex(firstEdge.getFirstVertex());
            this.vertices.add(firstEdge.getSecondVertex());
            while (edges.hasNext()) {
                Integer higherVertexId = edges.next().getSecondVertex();
                for (Integer lowerVertexId : this.vertices) {
                    this.outTriad.setSecondVertex(lowerVertexId);
                    this.outTriad.setThirdVertex(higherVertexId);
                    out.collect((Object)this.outTriad);
                }
                this.vertices.add(higherVertexId);
            }
        }
    }

    private static class EdgeByIdProjector
    implements MapFunction<EnumTrianglesDataTypes.Edge, EnumTrianglesDataTypes.Edge> {
        private EdgeByIdProjector() {
        }

        public EnumTrianglesDataTypes.Edge map(EnumTrianglesDataTypes.Edge inEdge) throws Exception {
            if (inEdge.getFirstVertex() > inEdge.getSecondVertex()) {
                inEdge.flipVertices();
            }
            return inEdge;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0;1"})
    public static class TupleEdgeConverter
    implements MapFunction<Tuple2<Integer, Integer>, EnumTrianglesDataTypes.Edge> {
        private final EnumTrianglesDataTypes.Edge outEdge = new EnumTrianglesDataTypes.Edge();

        public EnumTrianglesDataTypes.Edge map(Tuple2<Integer, Integer> t) throws Exception {
            this.outEdge.copyVerticesFromTuple2(t);
            return this.outEdge;
        }
    }
}

