/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.SorMergeJoinOperatorUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.SortMergeJoinFunction;
import org.apache.flink.table.runtime.operators.join.SortMergeJoinOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class BatchExecSortMergeJoin
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private final FlinkJoinType joinType;
    private final int[] leftKeys;
    private final int[] rightKeys;
    private final boolean[] filterNulls;
    @Nullable
    private final RexNode nonEquiCondition;
    private final boolean leftIsSmaller;

    public BatchExecSortMergeJoin(ReadableConfig tableConfig, FlinkJoinType joinType, int[] leftKeys, int[] rightKeys, boolean[] filterNulls, @Nullable RexNode nonEquiCondition, boolean leftIsSmaller, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecSortMergeJoin.class), ExecNodeContext.newPersistedConfig(BatchExecSortMergeJoin.class, tableConfig), Arrays.asList(leftInputProperty, rightInputProperty), (LogicalType)outputType, description);
        this.joinType = (FlinkJoinType)Preconditions.checkNotNull((Object)joinType);
        this.leftKeys = (int[])Preconditions.checkNotNull((Object)leftKeys);
        this.rightKeys = (int[])Preconditions.checkNotNull((Object)rightKeys);
        this.filterNulls = (boolean[])Preconditions.checkNotNull((Object)filterNulls);
        Preconditions.checkArgument((leftKeys.length > 0 && leftKeys.length == rightKeys.length ? 1 : 0) != 0);
        Preconditions.checkArgument((leftKeys.length == filterNulls.length ? 1 : 0) != 0);
        this.nonEquiCondition = nonEquiCondition;
        this.leftIsSmaller = leftIsSmaller;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        RowType leftType = (RowType)leftInputEdge.getOutputType();
        RowType rightType = (RowType)rightInputEdge.getOutputType();
        LogicalType[] keyFieldTypes = (LogicalType[])IntStream.of(this.leftKeys).mapToObj(arg_0 -> ((RowType)leftType).getTypeAt(arg_0)).toArray(LogicalType[]::new);
        RowType keyType = RowType.of((LogicalType[])keyFieldTypes);
        GeneratedJoinCondition condFunc = JoinUtil.generateConditionFunction((ReadableConfig)config, planner.getFlinkContext().getClassLoader(), this.nonEquiCondition, (LogicalType)leftType, (LogicalType)rightType);
        long externalBufferMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY)).getBytes();
        long sortMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_SORT_MEMORY)).getBytes();
        int externalBufferNum = 1;
        if (this.joinType == FlinkJoinType.FULL) {
            externalBufferNum = 2;
        }
        long managedMemory = externalBufferMemory * (long)externalBufferNum + sortMemory * 2L;
        SortMergeJoinFunction sortMergeJoinFunction = SorMergeJoinOperatorUtil.getSortMergeJoinFunction(planner.getFlinkContext().getClassLoader(), config, this.joinType, leftType, rightType, this.leftKeys, this.rightKeys, keyType, this.leftIsSmaller, this.filterNulls, condFunc, 1.0 * (double)externalBufferMemory / (double)managedMemory);
        Transformation<?> leftInputTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightInputTransform = rightInputEdge.translateToPlan(planner);
        return ExecNodeUtil.createTwoInputTransformation(leftInputTransform, rightInputTransform, this.createTransformationName(config), this.createTransformationDescription(config), SimpleOperatorFactory.of((StreamOperator)new SortMergeJoinOperator(sortMergeJoinFunction)), InternalTypeInfo.of((LogicalType)this.getOutputType()), rightInputTransform.getParallelism(), managedMemory, false);
    }
}

