/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ad;

import java.util.EnumSet;
import java.util.Set;

public enum AdDirSyncFlag {
    LDAP_DIRSYNC_OBJECT_SECURITY(1, "Object Security"),
    LDAP_DIRSYNC_ANCESTORS_FIRST_ORDER(2048, "Ancestors First Order"),
    LDAP_DIRSYNC_PUBLIC_DATA_ONLY(8192, "Public Data Only"),
    LDAP_DIRSYNC_INCREMENTAL_VALUES(Integer.MIN_VALUE, "Incremental Values");

    private int value;
    private String description;

    private AdDirSyncFlag(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.description;
    }

    public static Set<AdDirSyncFlag> getFlags(int value) {
        EnumSet<AdDirSyncFlag> result = EnumSet.noneOf(AdDirSyncFlag.class);
        for (AdDirSyncFlag flag : EnumSet.allOf(AdDirSyncFlag.class)) {
            if ((flag.getValue() & value) != flag.getValue()) continue;
            result.add(flag);
        }
        return result;
    }

    public static int getBitmask(Set<AdDirSyncFlag> flags) {
        int mask = 0;
        for (AdDirSyncFlag flag : flags) {
            mask += flag.getValue();
        }
        return mask;
    }
}

