/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.awt.Color;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.reflect.FieldUtilsTest;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.reflect.testbed.Annotated;
import org.apache.commons.lang3.reflect.testbed.GenericConsumer;
import org.apache.commons.lang3.reflect.testbed.GenericParent;
import org.apache.commons.lang3.reflect.testbed.PublicChild;
import org.apache.commons.lang3.reflect.testbed.StringParameterizedChild;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MethodUtilsTest
extends AbstractLangTest {
    private TestBean testBean;
    private final Map<Class<?>, Class<?>[]> classCache = new HashMap();

    MethodUtilsTest() {
    }

    private void expectMatchingAccessibleMethodParameterTypes(Class<?> cls, String methodName, Class<?>[] requestTypes, Class<?>[] actualTypes) {
        Method m = MethodUtils.getMatchingAccessibleMethod(cls, (String)methodName, (Class[])requestTypes);
        Assertions.assertNotNull((Object)m, (String)("could not find any matches for " + methodName + " (" + (requestTypes == null ? null : this.toString(requestTypes)) + ")"));
        Assertions.assertArrayEquals((Object[])actualTypes, (Object[])m.getParameterTypes(), (String)(this.toString(m.getParameterTypes()) + " not equals " + this.toString(actualTypes)));
    }

    @BeforeEach
    public void setUp() {
        this.testBean = new TestBean();
        this.classCache.clear();
    }

    private Class<?>[] singletonArray(Class<?> c) {
        Class<?>[] result = this.classCache.get(c);
        if (result == null) {
            result = new Class[]{c};
            this.classCache.put(c, result);
        }
        return result;
    }

    @Test
    void testConstructor() throws Exception {
        Assertions.assertNotNull(MethodUtils.class.getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    @Test
    void testDistance() throws Exception {
        Method distanceMethod = MethodUtils.getMatchingMethod(MethodUtils.class, (String)"distance", (Class[])new Class[]{Class[].class, Class[].class});
        distanceMethod.setAccessible(true);
        Assertions.assertEquals((Object)-1, (Object)distanceMethod.invoke(null, new Class[]{String.class}, new Class[]{Date.class}));
        Assertions.assertEquals((Object)0, (Object)distanceMethod.invoke(null, new Class[]{Date.class}, new Class[]{Date.class}));
        Assertions.assertEquals((Object)1, (Object)distanceMethod.invoke(null, new Class[]{Integer.class}, new Class[]{ClassUtils.wrapperToPrimitive(Integer.class)}));
        Assertions.assertEquals((Object)2, (Object)distanceMethod.invoke(null, new Class[]{Integer.class}, new Class[]{Object.class}));
        distanceMethod.setAccessible(false);
    }

    @Test
    void testGetAccessibleInterfaceMethod() throws Exception {
        Class[][] p;
        for (Class[] element : p = new Class[][]{ArrayUtils.EMPTY_CLASS_ARRAY, null}) {
            Method method = TestMutable.class.getMethod("getValue", element);
            Method accessibleMethod = MethodUtils.getAccessibleMethod((Method)method);
            Assertions.assertNotSame((Object)accessibleMethod, (Object)method);
            Assertions.assertSame(Mutable.class, accessibleMethod.getDeclaringClass());
        }
    }

    @Test
    void testGetAccessibleInterfaceMethodFromDescription() {
        Class[][] p;
        for (Class[] element : p = new Class[][]{ArrayUtils.EMPTY_CLASS_ARRAY, null}) {
            Method accessibleMethod = MethodUtils.getAccessibleMethod(TestMutable.class, (String)"getValue", (Class[])element);
            Assertions.assertSame(Mutable.class, accessibleMethod.getDeclaringClass());
        }
    }

    @Test
    void testGetAccessibleMethodInaccessible() throws Exception {
        Method expected = TestBean.class.getDeclaredMethod("privateStuff", new Class[0]);
        Method actual = MethodUtils.getAccessibleMethod((Method)expected);
        Assertions.assertNull((Object)actual);
    }

    @Test
    void testGetAccessibleMethodPrivateInterface() throws Exception {
        Method expected = TestBeanWithInterfaces.class.getMethod("foo", new Class[0]);
        Assertions.assertNotNull((Object)expected);
        Method actual = MethodUtils.getAccessibleMethod(TestBeanWithInterfaces.class, (String)"foo", (Class[])new Class[0]);
        Assertions.assertNull((Object)actual);
    }

    @Test
    void testGetAccessiblePublicMethod() throws Exception {
        Assertions.assertSame(MutableObject.class, MethodUtils.getAccessibleMethod((Method)MutableObject.class.getMethod("getValue", ArrayUtils.EMPTY_CLASS_ARRAY)).getDeclaringClass());
    }

    @Test
    void testGetAccessiblePublicMethodFromDescription() {
        Assertions.assertSame(MutableObject.class, MethodUtils.getAccessibleMethod(MutableObject.class, (String)"getValue", (Class[])ArrayUtils.EMPTY_CLASS_ARRAY).getDeclaringClass());
    }

    @Test
    void testGetAnnotationIllegalArgumentException1() {
        LangAssertions.assertNullPointerException(() -> MethodUtils.getAnnotation((Method)FieldUtilsTest.class.getDeclaredMethods()[0], null, (boolean)true, (boolean)true));
    }

    @Test
    void testGetAnnotationIllegalArgumentException2() {
        LangAssertions.assertNullPointerException(() -> MethodUtils.getAnnotation(null, Annotated.class, (boolean)true, (boolean)true));
    }

    @Test
    void testGetAnnotationIllegalArgumentException3() {
        LangAssertions.assertNullPointerException(() -> MethodUtils.getAnnotation(null, null, (boolean)true, (boolean)true));
    }

    @Test
    void testGetAnnotationNotSearchSupersAndNotIgnoreAccess() throws NoSuchMethodException {
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("parentNotAnnotatedMethod", new Class[0]), Annotated.class, (boolean)false, (boolean)false));
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("doIt", new Class[0]), Annotated.class, (boolean)false, (boolean)false));
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("parentProtectedAnnotatedMethod", new Class[0]), Annotated.class, (boolean)false, (boolean)false));
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getDeclaredMethod("privateAnnotatedMethod", new Class[0]), Annotated.class, (boolean)false, (boolean)false));
        Assertions.assertNotNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("publicAnnotatedMethod", new Class[0]), Annotated.class, (boolean)false, (boolean)false));
    }

    @Test
    void testGetAnnotationNotSearchSupersButIgnoreAccess() throws NoSuchMethodException {
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("parentNotAnnotatedMethod", new Class[0]), Annotated.class, (boolean)false, (boolean)true));
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("doIt", new Class[0]), Annotated.class, (boolean)false, (boolean)true));
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("parentProtectedAnnotatedMethod", new Class[0]), Annotated.class, (boolean)false, (boolean)true));
        Assertions.assertNotNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getDeclaredMethod("privateAnnotatedMethod", new Class[0]), Annotated.class, (boolean)false, (boolean)true));
        Assertions.assertNotNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("publicAnnotatedMethod", new Class[0]), Annotated.class, (boolean)false, (boolean)true));
    }

    @Test
    void testGetAnnotationSearchSupersAndIgnoreAccess() throws NoSuchMethodException {
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("parentNotAnnotatedMethod", new Class[0]), Annotated.class, (boolean)true, (boolean)true));
        Assertions.assertNotNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("doIt", new Class[0]), Annotated.class, (boolean)true, (boolean)true));
        Assertions.assertNotNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("parentProtectedAnnotatedMethod", new Class[0]), Annotated.class, (boolean)true, (boolean)true));
        Assertions.assertNotNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getDeclaredMethod("privateAnnotatedMethod", new Class[0]), Annotated.class, (boolean)true, (boolean)true));
        Assertions.assertNotNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("publicAnnotatedMethod", new Class[0]), Annotated.class, (boolean)true, (boolean)true));
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)StringParameterizedChild.class.getMethod("parentNotAnnotatedMethod", String.class), Annotated.class, (boolean)true, (boolean)true));
        Assertions.assertNotNull((Object)MethodUtils.getAnnotation((Method)StringParameterizedChild.class.getMethod("parentProtectedAnnotatedMethod", String.class), Annotated.class, (boolean)true, (boolean)true));
        Assertions.assertNotNull((Object)MethodUtils.getAnnotation((Method)StringParameterizedChild.class.getDeclaredMethod("privateAnnotatedMethod", String.class), Annotated.class, (boolean)true, (boolean)true));
        Assertions.assertNotNull((Object)MethodUtils.getAnnotation((Method)StringParameterizedChild.class.getMethod("publicAnnotatedMethod", String.class), Annotated.class, (boolean)true, (boolean)true));
    }

    @Test
    void testGetAnnotationSearchSupersButNotIgnoreAccess() throws NoSuchMethodException {
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("parentNotAnnotatedMethod", new Class[0]), Annotated.class, (boolean)true, (boolean)false));
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("doIt", new Class[0]), Annotated.class, (boolean)true, (boolean)false));
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("parentProtectedAnnotatedMethod", new Class[0]), Annotated.class, (boolean)true, (boolean)false));
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getDeclaredMethod("privateAnnotatedMethod", new Class[0]), Annotated.class, (boolean)true, (boolean)false));
        Assertions.assertNotNull((Object)MethodUtils.getAnnotation((Method)PublicChild.class.getMethod("publicAnnotatedMethod", new Class[0]), Annotated.class, (boolean)true, (boolean)false));
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)StringParameterizedChild.class.getMethod("parentNotAnnotatedMethod", String.class), Annotated.class, (boolean)true, (boolean)false));
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)StringParameterizedChild.class.getMethod("parentProtectedAnnotatedMethod", String.class), Annotated.class, (boolean)true, (boolean)false));
        Assertions.assertNull((Object)MethodUtils.getAnnotation((Method)StringParameterizedChild.class.getDeclaredMethod("privateAnnotatedMethod", String.class), Annotated.class, (boolean)true, (boolean)false));
        Assertions.assertNotNull((Object)MethodUtils.getAnnotation((Method)StringParameterizedChild.class.getMethod("publicAnnotatedMethod", String.class), Annotated.class, (boolean)true, (boolean)false));
    }

    @Test
    void testGetMatchingAccessibleMethod() {
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", ArrayUtils.EMPTY_CLASS_ARRAY, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", null, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(String.class), this.singletonArray(String.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Object.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Boolean.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Byte.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Byte.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Short.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Short.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Character.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Character.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Integer.class), this.singletonArray(Integer.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Integer.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Long.class), this.singletonArray(Long.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Long.TYPE), this.singletonArray(Long.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Float.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Float.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Double.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Double.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Double.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", new Class[]{String.class, String.class}, new Class[]{String[].class});
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", new Class[]{Integer.TYPE, String.class, String.class}, new Class[]{Integer.class, String[].class});
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testOne", this.singletonArray(ParentObject.class), this.singletonArray(ParentObject.class));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testOne", this.singletonArray(ChildObject.class), this.singletonArray(ParentObject.class));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testTwo", this.singletonArray(ParentObject.class), this.singletonArray(GrandParentObject.class));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testTwo", this.singletonArray(ChildObject.class), this.singletonArray(ChildInterface.class));
        this.expectMatchingAccessibleMethodParameterTypes(Files.class, "exists", this.singletonArray(Path.class), new Class[]{Path.class, LinkOption[].class});
    }

    @Test
    void testGetMatchingMethod() throws NoSuchMethodException {
        Assertions.assertEquals((Object)MethodUtils.getMatchingMethod(GetMatchingMethodClass.class, (String)"testMethod", (Class[])new Class[0]), (Object)GetMatchingMethodClass.class.getMethod("testMethod", new Class[0]));
        Assertions.assertEquals((Object)MethodUtils.getMatchingMethod(GetMatchingMethodClass.class, (String)"testMethod", (Class[])new Class[]{Long.TYPE}), (Object)GetMatchingMethodClass.class.getMethod("testMethod", Long.TYPE));
        Assertions.assertEquals((Object)MethodUtils.getMatchingMethod(GetMatchingMethodClass.class, (String)"testMethod", (Class[])new Class[]{Long.class}), (Object)GetMatchingMethodClass.class.getMethod("testMethod", Long.class));
        Assertions.assertEquals((Object)MethodUtils.getMatchingMethod(GetMatchingMethodClass.class, (String)"testMethod", (Class[])new Class[]{null}), (Object)GetMatchingMethodClass.class.getMethod("testMethod", Long.class));
        Assertions.assertThrows(IllegalStateException.class, () -> MethodUtils.getMatchingMethod(GetMatchingMethodClass.class, (String)"testMethod2", (Class[])new Class[]{null}));
        Assertions.assertEquals((Object)MethodUtils.getMatchingMethod(GetMatchingMethodClass.class, (String)"testMethod3", (Class[])new Class[]{Long.TYPE, Long.class}), (Object)GetMatchingMethodClass.class.getMethod("testMethod3", Long.TYPE, Long.class));
        Assertions.assertEquals((Object)MethodUtils.getMatchingMethod(GetMatchingMethodClass.class, (String)"testMethod3", (Class[])new Class[]{Long.class, Long.TYPE}), (Object)GetMatchingMethodClass.class.getMethod("testMethod3", Long.class, Long.TYPE));
        Assertions.assertEquals((Object)MethodUtils.getMatchingMethod(GetMatchingMethodClass.class, (String)"testMethod3", (Class[])new Class[]{null, Long.TYPE}), (Object)GetMatchingMethodClass.class.getMethod("testMethod3", Long.class, Long.TYPE));
        Assertions.assertEquals((Object)MethodUtils.getMatchingMethod(GetMatchingMethodClass.class, (String)"testMethod3", (Class[])new Class[]{Long.TYPE, null}), (Object)GetMatchingMethodClass.class.getMethod("testMethod3", Long.TYPE, Long.class));
        Assertions.assertThrows(IllegalStateException.class, () -> MethodUtils.getMatchingMethod(GetMatchingMethodClass.class, (String)"testMethod4", (Class[])new Class[]{null, null}));
        Assertions.assertEquals((Object)MethodUtils.getMatchingMethod(GetMatchingMethodImpl.class, (String)"testMethod5", (Class[])new Class[]{RuntimeException.class}), (Object)GetMatchingMethodImpl.class.getMethod("testMethod5", Exception.class));
        Assertions.assertEquals((Object)GetMatchingMethodImpl.class.getMethod("testMethod6", new Class[0]), (Object)MethodUtils.getMatchingMethod(GetMatchingMethodImpl.class, (String)"testMethod6", (Class[])new Class[0]));
        LangAssertions.assertNullPointerException(() -> MethodUtils.getMatchingMethod(null, (String)"testMethod5", (Class[])new Class[]{RuntimeException.class}));
    }

    @Test
    void testGetMethodObject() throws Exception {
        Assertions.assertEquals((Object)MutableObject.class.getMethod("getValue", ArrayUtils.EMPTY_CLASS_ARRAY), (Object)MethodUtils.getMethodObject(MutableObject.class, (String)"getValue", (Class[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assertions.assertNull((Object)MethodUtils.getMethodObject(MutableObject.class, (String)"does not exist, at all", (Class[])ArrayUtils.EMPTY_CLASS_ARRAY));
    }

    @Test
    @Annotated
    public void testGetMethodsListWithAnnotation() throws NoSuchMethodException {
        Assertions.assertEquals((int)0, (int)MethodUtils.getMethodsListWithAnnotation(Object.class, Annotated.class).size());
        List methodWithAnnotation = MethodUtils.getMethodsListWithAnnotation(MethodUtilsTest.class, Annotated.class);
        Assertions.assertEquals((int)2, (int)methodWithAnnotation.size());
        Assertions.assertTrue((boolean)methodWithAnnotation.contains(MethodUtilsTest.class.getMethod("testGetMethodsWithAnnotation", new Class[0])));
        Assertions.assertTrue((boolean)methodWithAnnotation.contains(MethodUtilsTest.class.getMethod("testGetMethodsListWithAnnotation", new Class[0])));
    }

    @Test
    void testGetMethodsListWithAnnotationNullPointerException1() {
        LangAssertions.assertNullPointerException(() -> MethodUtils.getMethodsListWithAnnotation(FieldUtilsTest.class, null));
    }

    @Test
    void testGetMethodsListWithAnnotationNullPointerException2() {
        LangAssertions.assertNullPointerException(() -> MethodUtils.getMethodsListWithAnnotation(null, Annotated.class));
    }

    @Test
    void testGetMethodsListWithAnnotationNullPointerException3() {
        LangAssertions.assertNullPointerException(() -> MethodUtils.getMethodsListWithAnnotation(null, null));
    }

    @Test
    @Annotated
    public void testGetMethodsWithAnnotation() throws NoSuchMethodException {
        Assertions.assertArrayEquals((Object[])new Method[0], (Object[])MethodUtils.getMethodsWithAnnotation(Object.class, Annotated.class));
        Object[] methodsWithAnnotation = MethodUtils.getMethodsWithAnnotation(MethodUtilsTest.class, Annotated.class);
        Assertions.assertEquals((int)2, (int)methodsWithAnnotation.length);
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])methodsWithAnnotation, (Object)MethodUtilsTest.class.getMethod("testGetMethodsWithAnnotation", new Class[0])));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])methodsWithAnnotation, (Object)MethodUtilsTest.class.getMethod("testGetMethodsListWithAnnotation", new Class[0])));
    }

    @Test
    void testGetMethodsWithAnnotationIllegalArgumentException1() {
        LangAssertions.assertNullPointerException(() -> MethodUtils.getMethodsWithAnnotation(FieldUtilsTest.class, null));
    }

    @Test
    void testGetMethodsWithAnnotationIllegalArgumentException2() {
        LangAssertions.assertNullPointerException(() -> MethodUtils.getMethodsWithAnnotation(null, Annotated.class));
    }

    @Test
    void testGetMethodsWithAnnotationIllegalArgumentException3() {
        LangAssertions.assertNullPointerException(() -> MethodUtils.getMethodsWithAnnotation(null, null));
    }

    @Test
    void testGetMethodsWithAnnotationNotSearchSupersAndNotIgnoreAccess() {
        Assertions.assertArrayEquals((Object[])new Method[0], (Object[])MethodUtils.getMethodsWithAnnotation(Object.class, Annotated.class, (boolean)false, (boolean)false));
        Method[] methodsWithAnnotation = MethodUtils.getMethodsWithAnnotation(PublicChild.class, Annotated.class, (boolean)false, (boolean)false);
        Assertions.assertEquals((int)1, (int)methodsWithAnnotation.length);
        Assertions.assertEquals((Object)"PublicChild.publicAnnotatedMethod", (Object)(methodsWithAnnotation[0].getDeclaringClass().getSimpleName() + '.' + methodsWithAnnotation[0].getName()));
    }

    @Test
    void testGetMethodsWithAnnotationNotSearchSupersButIgnoreAccess() {
        Assertions.assertArrayEquals((Object[])new Method[0], (Object[])MethodUtils.getMethodsWithAnnotation(Object.class, Annotated.class, (boolean)false, (boolean)true));
        Method[] methodsWithAnnotation = MethodUtils.getMethodsWithAnnotation(PublicChild.class, Annotated.class, (boolean)false, (boolean)true);
        Assertions.assertEquals((int)2, (int)methodsWithAnnotation.length);
        Assertions.assertEquals((Object)"PublicChild", (Object)methodsWithAnnotation[0].getDeclaringClass().getSimpleName());
        Assertions.assertEquals((Object)"PublicChild", (Object)methodsWithAnnotation[1].getDeclaringClass().getSimpleName());
        Assertions.assertTrue((boolean)methodsWithAnnotation[0].getName().endsWith("AnnotatedMethod"));
        Assertions.assertTrue((boolean)methodsWithAnnotation[1].getName().endsWith("AnnotatedMethod"));
    }

    @Test
    void testGetMethodsWithAnnotationSearchSupersAndIgnoreAccess() {
        Assertions.assertArrayEquals((Object[])new Method[0], (Object[])MethodUtils.getMethodsWithAnnotation(Object.class, Annotated.class, (boolean)true, (boolean)true));
        Method[] methodsWithAnnotation = MethodUtils.getMethodsWithAnnotation(PublicChild.class, Annotated.class, (boolean)true, (boolean)true);
        Assertions.assertEquals((int)4, (int)methodsWithAnnotation.length);
        Assertions.assertEquals((Object)"PublicChild", (Object)methodsWithAnnotation[0].getDeclaringClass().getSimpleName());
        Assertions.assertEquals((Object)"PublicChild", (Object)methodsWithAnnotation[1].getDeclaringClass().getSimpleName());
        Assertions.assertTrue((boolean)methodsWithAnnotation[0].getName().endsWith("AnnotatedMethod"));
        Assertions.assertTrue((boolean)methodsWithAnnotation[1].getName().endsWith("AnnotatedMethod"));
        Assertions.assertEquals((Object)"Foo.doIt", (Object)(methodsWithAnnotation[2].getDeclaringClass().getSimpleName() + '.' + methodsWithAnnotation[2].getName()));
        Assertions.assertEquals((Object)"Parent.parentProtectedAnnotatedMethod", (Object)(methodsWithAnnotation[3].getDeclaringClass().getSimpleName() + '.' + methodsWithAnnotation[3].getName()));
    }

    @Test
    void testGetMethodsWithAnnotationSearchSupersButNotIgnoreAccess() {
        Assertions.assertArrayEquals((Object[])new Method[0], (Object[])MethodUtils.getMethodsWithAnnotation(Object.class, Annotated.class, (boolean)true, (boolean)false));
        Method[] methodsWithAnnotation = MethodUtils.getMethodsWithAnnotation(PublicChild.class, Annotated.class, (boolean)true, (boolean)false);
        Assertions.assertEquals((int)2, (int)methodsWithAnnotation.length);
        Assertions.assertEquals((Object)"PublicChild.publicAnnotatedMethod", (Object)(methodsWithAnnotation[0].getDeclaringClass().getSimpleName() + '.' + methodsWithAnnotation[0].getName()));
        Assertions.assertEquals((Object)"Foo.doIt", (Object)(methodsWithAnnotation[1].getDeclaringClass().getSimpleName() + '.' + methodsWithAnnotation[1].getName()));
    }

    @Test
    void testGetOverrideHierarchyExcludingInterfaces() {
        Method method = MethodUtils.getAccessibleMethod(StringParameterizedChild.class, (String)"consume", (Class[])new Class[]{String.class});
        Iterator<MethodDescriptor> expected = Arrays.asList(new MethodDescriptor(StringParameterizedChild.class, "consume", new Type[]{String.class}), new MethodDescriptor(GenericParent.class, "consume", GenericParent.class.getTypeParameters()[0])).iterator();
        for (Method m : MethodUtils.getOverrideHierarchy((Method)method, (ClassUtils.Interfaces)ClassUtils.Interfaces.EXCLUDE)) {
            Assertions.assertTrue((boolean)expected.hasNext());
            MethodDescriptor md = expected.next();
            Assertions.assertEquals(md.declaringClass, m.getDeclaringClass());
            Assertions.assertEquals((Object)md.name, (Object)m.getName());
            Assertions.assertEquals((int)md.parameterTypes.length, (int)m.getParameterTypes().length);
            for (int i = 0; i < md.parameterTypes.length; ++i) {
                Assertions.assertTrue((boolean)TypeUtils.equals((Type)md.parameterTypes[i], (Type)m.getGenericParameterTypes()[i]));
            }
        }
        Assertions.assertFalse((boolean)expected.hasNext());
    }

    @Test
    void testGetOverrideHierarchyIncludingInterfaces() {
        Method method = MethodUtils.getAccessibleMethod(StringParameterizedChild.class, (String)"consume", (Class[])new Class[]{String.class});
        Iterator<MethodDescriptor> expected = Arrays.asList(new MethodDescriptor(StringParameterizedChild.class, "consume", new Type[]{String.class}), new MethodDescriptor(GenericParent.class, "consume", GenericParent.class.getTypeParameters()[0]), new MethodDescriptor(GenericConsumer.class, "consume", GenericConsumer.class.getTypeParameters()[0])).iterator();
        for (Method m : MethodUtils.getOverrideHierarchy((Method)method, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE)) {
            Assertions.assertTrue((boolean)expected.hasNext());
            MethodDescriptor md = expected.next();
            Assertions.assertEquals(md.declaringClass, m.getDeclaringClass());
            Assertions.assertEquals((Object)md.name, (Object)m.getName());
            Assertions.assertEquals((int)md.parameterTypes.length, (int)m.getParameterTypes().length);
            for (int i = 0; i < md.parameterTypes.length; ++i) {
                Assertions.assertTrue((boolean)TypeUtils.equals((Type)md.parameterTypes[i], (Type)m.getGenericParameterTypes()[i]));
            }
        }
        Assertions.assertFalse((boolean)expected.hasNext());
    }

    @Test
    void testInvokeExactMethod() throws Exception {
        Assertions.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assertions.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo"));
        Assertions.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])null));
        Assertions.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", null, null));
        Assertions.assertEquals((Object)"foo(String)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{""}));
        Assertions.assertEquals((Object)"foo(Object)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{new Object()}));
        Assertions.assertEquals((Object)"foo(Integer)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        Assertions.assertEquals((Object)"foo(double)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE}));
        Assertions.assertThrows(NoSuchMethodException.class, () -> MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        Assertions.assertThrows(NoSuchMethodException.class, () -> MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.LONG_ONE}));
        Assertions.assertThrows(NoSuchMethodException.class, () -> MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{Boolean.TRUE}));
        Assertions.assertThrows(NullPointerException.class, () -> MethodUtils.invokeExactMethod(null, (String)"foo", (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        Assertions.assertThrows(NullPointerException.class, () -> MethodUtils.invokeExactMethod((Object)this.testBean, null, (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        Assertions.assertThrows(NullPointerException.class, () -> MethodUtils.invokeExactMethod(null, (String)"foo", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE}));
        Assertions.assertThrows(NullPointerException.class, () -> MethodUtils.invokeExactMethod((Object)this.testBean, null, (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE}));
    }

    @Test
    void testInvokeExactStaticMethod() throws Exception {
        Assertions.assertEquals((Object)"bar()", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assertions.assertEquals((Object)"bar()", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])null));
        Assertions.assertEquals((Object)"bar()", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", null, null));
        Assertions.assertEquals((Object)"bar(String)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{""}));
        Assertions.assertEquals((Object)"bar(Object)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{new Object()}));
        Assertions.assertEquals((Object)"bar(Integer)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        Assertions.assertEquals((Object)"bar(double)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE}));
        Assertions.assertThrows(NoSuchMethodException.class, () -> MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        Assertions.assertThrows(NoSuchMethodException.class, () -> MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.LONG_ONE}));
        Assertions.assertThrows(NoSuchMethodException.class, () -> MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{Boolean.TRUE}));
    }

    @Test
    void testInvokeJavaVarargsOverloadingResolution() throws Exception {
        Assertions.assertEquals((Object)"Byte...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{(byte)1, (byte)2}));
        Assertions.assertEquals((Object)"Short...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{(short)1, (short)2}));
        Assertions.assertEquals((Object)"Integer...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1, 2}));
        Assertions.assertEquals((Object)"Long...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1L, 2L}));
        Assertions.assertEquals((Object)"Float...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{Float.valueOf(1.0f), Float.valueOf(2.0f)}));
        Assertions.assertEquals((Object)"Double...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1.0, 2.0}));
        Assertions.assertEquals((Object)"Character...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{Character.valueOf('a'), Character.valueOf('b')}));
        Assertions.assertEquals((Object)"String...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{"a", "b"}));
        Assertions.assertEquals((Object)"Boolean...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{true, false}));
        Assertions.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1, "s"}));
        Assertions.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1, true}));
        Assertions.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1.1, true}));
        Assertions.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{Character.valueOf('c'), true}));
        Assertions.assertEquals((Object)"Number...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1, 1.1}));
        Assertions.assertEquals((Object)"Number...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1, 1L}));
        Assertions.assertEquals((Object)"Number...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1.0, Float.valueOf(1.0f)}));
        Assertions.assertEquals((Object)"Number...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{(short)1, (byte)1}));
        Assertions.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1, Character.valueOf('c')}));
        Assertions.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{Character.valueOf('c'), "s"}));
        Assertions.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assertions.assertEquals((Object)"Number...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"numOverload", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
    }

    @Test
    void testInvokeMethod() throws Exception {
        Assertions.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assertions.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo"));
        Assertions.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])null));
        Assertions.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", null, null));
        Assertions.assertEquals((Object)"foo(String)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{""}));
        Assertions.assertEquals((Object)"foo(Object)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{new Object()}));
        Assertions.assertEquals((Object)"foo(Object)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{Boolean.TRUE}));
        Assertions.assertEquals((Object)"foo(Integer)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        Assertions.assertEquals((Object)"foo(int)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        Assertions.assertEquals((Object)"foo(long)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.LONG_ONE}));
        Assertions.assertEquals((Object)"foo(double)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}));
        Assertions.assertEquals((Object)"foo(String...)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{"a", "b", "c"}));
        Assertions.assertEquals((Object)"foo(String...)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{"a", "b", "c"}));
        Assertions.assertEquals((Object)"foo(int, String...)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{5, "a", "b", "c"}));
        Assertions.assertEquals((Object)"foo(long...)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{1L, 2L}));
        Assertions.assertThrows(NoSuchMethodException.class, () -> MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{1, 2}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"String...", (Object)new String[]{"x", "y"}), MethodUtils.invokeMethod((Object)this.testBean, (String)"varOverloadEcho", (Object[])new Object[]{"x", "y"}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"Number...", (Object)new Number[]{17, 23, 42}), MethodUtils.invokeMethod((Object)this.testBean, (String)"varOverloadEcho", (Object[])new Object[]{17, 23, 42}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"String...", (Object)new String[]{"x", "y"}), MethodUtils.invokeMethod((Object)this.testBean, (String)"varOverloadEcho", (Object[])new Object[]{"x", "y"}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"Number...", (Object)new Number[]{17, 23, 42}), MethodUtils.invokeMethod((Object)this.testBean, (String)"varOverloadEcho", (Object[])new Object[]{17, 23, 42}));
        LangAssertions.assertNullPointerException(() -> MethodUtils.invokeMethod(null, (String)"foo", (Object[])new Object[]{1, 2}));
        LangAssertions.assertNullPointerException(() -> MethodUtils.invokeMethod((Object)this.testBean, null, (Object[])new Object[]{1, 2}));
    }

    @Test
    void testInvokeMethod_VarArgsNotUniqueResolvable() throws Exception {
        Assertions.assertEquals((Object)"Boolean...", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"varOverload", (Object[])new Object[]{null}));
        Assertions.assertEquals((Object)"Object...", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"varOverload", (Object[])null));
    }

    @Test
    void testInvokeMethod_VarArgsWithNullValues() throws Exception {
        Assertions.assertEquals((Object)"String...", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"varOverload", (Object[])new Object[]{"a", null, "c"}));
        Assertions.assertEquals((Object)"String...", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"varOverload", (Object[])new Object[]{"a", "b", null}));
    }

    @Test
    void testInvokeMethodForceAccessNoArgs() throws Exception {
        Assertions.assertEquals((Object)"privateStringStuff()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (boolean)true, (String)"privateStringStuff"));
    }

    @Test
    void testInvokeMethodForceAccessWithArgs() throws Exception {
        Assertions.assertEquals((Object)"privateStringStuff(Integer)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (boolean)true, (String)"privateStringStuff", (Object[])new Object[]{5}));
        Assertions.assertEquals((Object)"privateStringStuff(double)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (boolean)true, (String)"privateStringStuff", (Object[])new Object[]{5.0}));
        Assertions.assertEquals((Object)"privateStringStuff(String)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (boolean)true, (String)"privateStringStuff", (Object[])new Object[]{"Hi There"}));
        Assertions.assertEquals((Object)"privateStringStuff(Object)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (boolean)true, (String)"privateStringStuff", (Object[])new Object[]{new Date()}));
        LangAssertions.assertNullPointerException(() -> MethodUtils.invokeMethod(null, (boolean)true, (String)"privateStringStuff", (Object[])new Object[]{"Hi There"}));
        LangAssertions.assertNullPointerException(() -> MethodUtils.invokeMethod((Object)this.testBean, (boolean)true, null, (Object[])new Object[]{"Hi There"}));
    }

    @Test
    void testInvokeStaticMethod() throws Exception {
        Assertions.assertEquals((Object)"bar()", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assertions.assertEquals((Object)"bar()", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])null));
        Assertions.assertEquals((Object)"bar()", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", null, null));
        Assertions.assertEquals((Object)"bar(String)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{""}));
        Assertions.assertEquals((Object)"bar(Object)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{new Object()}));
        Assertions.assertEquals((Object)"bar(Object)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{Boolean.TRUE}));
        Assertions.assertEquals((Object)"bar(Integer)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        Assertions.assertEquals((Object)"bar(int)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        Assertions.assertEquals((Object)"bar(double)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}));
        Assertions.assertEquals((Object)"bar(String...)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{"a", "b"}));
        Assertions.assertEquals((Object)"bar(long...)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{1L, 2L}));
        Assertions.assertEquals((Object)"bar(int, String...)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.INTEGER_ONE, "a", "b"}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"String...", (Object)new String[]{"x", "y"}), MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverloadEchoStatic", (Object[])new Object[]{"x", "y"}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"Number...", (Object)new Number[]{17, 23, 42}), MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverloadEchoStatic", (Object[])new Object[]{17, 23, 42}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"String...", (Object)new String[]{"x", "y"}), MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverloadEchoStatic", (Object[])new Object[]{"x", "y"}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"Number...", (Object)new Number[]{17, 23, 42}), MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverloadEchoStatic", (Object[])new Object[]{17, 23, 42}));
        Assertions.assertThrows(NoSuchMethodException.class, () -> MethodUtils.invokeStaticMethod(TestBean.class, (String)"does_not_exist", (Object[])new Object[0]));
    }

    @Test
    void testNullArgument() {
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "oneParameter", this.singletonArray(null), this.singletonArray(String.class));
    }

    @Test
    void testVarArgsUnboxing() throws Exception {
        TestBean testBean = new TestBean();
        int[] actual = (int[])MethodUtils.invokeMethod((Object)testBean, (String)"unboxing", (Object[])new Object[]{1, 2});
        Assertions.assertArrayEquals((int[])new int[]{1, 2}, (int[])actual);
    }

    private String toString(Class<?>[] c) {
        return Arrays.asList(c).toString();
    }

    @Test
    public void verifyJavaVarargsOverloadingResolution() {
        Assertions.assertEquals((Object)"Byte...", (Object)TestBean.varOverload((byte)1, (byte)2));
        Assertions.assertEquals((Object)"Short...", (Object)TestBean.varOverload((short)1, (short)2));
        Assertions.assertEquals((Object)"Integer...", (Object)TestBean.varOverload(1, 2));
        Assertions.assertEquals((Object)"Long...", (Object)TestBean.varOverload(1L, 2L));
        Assertions.assertEquals((Object)"Float...", (Object)TestBean.varOverload(Float.valueOf(1.0f), Float.valueOf(2.0f)));
        Assertions.assertEquals((Object)"Double...", (Object)TestBean.varOverload(1.0, 2.0));
        Assertions.assertEquals((Object)"Character...", (Object)TestBean.varOverload(Character.valueOf('a'), Character.valueOf('b')));
        Assertions.assertEquals((Object)"String...", (Object)TestBean.varOverload("a", "b"));
        Assertions.assertEquals((Object)"Boolean...", (Object)TestBean.varOverload(true, false));
        Assertions.assertEquals((Object)"Object...", (Object)TestBean.varOverload(1, "s"));
        Assertions.assertEquals((Object)"Object...", (Object)TestBean.varOverload(1, true));
        Assertions.assertEquals((Object)"Object...", (Object)TestBean.varOverload(1.1, true));
        Assertions.assertEquals((Object)"Object...", (Object)TestBean.varOverload(Character.valueOf('c'), true));
        Assertions.assertEquals((Object)"Number...", (Object)TestBean.varOverload(1, 1.1));
        Assertions.assertEquals((Object)"Number...", (Object)TestBean.varOverload(1, 1L));
        Assertions.assertEquals((Object)"Number...", (Object)TestBean.varOverload(1.0, Float.valueOf(1.0f)));
        Assertions.assertEquals((Object)"Number...", (Object)TestBean.varOverload((short)1, (byte)1));
        Assertions.assertEquals((Object)"Object...", (Object)TestBean.varOverload(1, Character.valueOf('c')));
        Assertions.assertEquals((Object)"Object...", (Object)TestBean.varOverload(Character.valueOf('c'), "s"));
    }

    public static class TestBean {
        public static String bar() {
            return "bar()";
        }

        public static String bar(double d) {
            return "bar(double)";
        }

        public static String bar(int i) {
            return "bar(int)";
        }

        public static String bar(Integer i) {
            return "bar(Integer)";
        }

        public static String bar(Integer i, String ... s) {
            return "bar(int, String...)";
        }

        public static String bar(long ... s) {
            return "bar(long...)";
        }

        public static String bar(Object o) {
            return "bar(Object)";
        }

        public static String bar(String s) {
            return "bar(String)";
        }

        public static String bar(String ... s) {
            return "bar(String...)";
        }

        public static String numOverload(Byte ... args) {
            return "Byte...";
        }

        public static String numOverload(Double ... args) {
            return "Double...";
        }

        public static String numOverload(Float ... args) {
            return "Float...";
        }

        public static String numOverload(Integer ... args) {
            return "Integer...";
        }

        public static String numOverload(Long ... args) {
            return "Long...";
        }

        public static String numOverload(Number ... args) {
            return "Number...";
        }

        public static String numOverload(Short ... args) {
            return "Short...";
        }

        public static void oneParameterStatic(String s) {
        }

        public static String varOverload(Boolean ... args) {
            return "Boolean...";
        }

        public static String varOverload(Byte ... args) {
            return "Byte...";
        }

        public static String varOverload(Character ... args) {
            return "Character...";
        }

        public static String varOverload(Double ... args) {
            return "Double...";
        }

        public static String varOverload(Float ... args) {
            return "Float...";
        }

        public static String varOverload(Integer ... args) {
            return "Integer...";
        }

        public static String varOverload(Long ... args) {
            return "Long...";
        }

        public static String varOverload(Number ... args) {
            return "Number...";
        }

        public static String varOverload(Object ... args) {
            return "Object...";
        }

        public static String varOverload(Short ... args) {
            return "Short...";
        }

        public static String varOverload(String ... args) {
            return "String...";
        }

        public static ImmutablePair<String, Object[]> varOverloadEchoStatic(Number ... args) {
            return new ImmutablePair((Object)"Number...", (Object)args);
        }

        public static ImmutablePair<String, Object[]> varOverloadEchoStatic(String ... args) {
            return new ImmutablePair((Object)"String...", (Object)args);
        }

        static void verify(ImmutablePair<String, Object[]> a, ImmutablePair<String, Object[]> b) {
            Assertions.assertEquals((Object)a.getLeft(), (Object)b.getLeft());
            Assertions.assertArrayEquals((Object[])((Object[])a.getRight()), (Object[])((Object[])b.getRight()));
        }

        static void verify(ImmutablePair<String, Object[]> a, Object obj) {
            ImmutablePair pair = (ImmutablePair)obj;
            TestBean.verify(a, (ImmutablePair<String, Object[]>)pair);
        }

        public String foo() {
            return "foo()";
        }

        public String foo(double d) {
            return "foo(double)";
        }

        public String foo(int i) {
            return "foo(int)";
        }

        public String foo(Integer i) {
            return "foo(Integer)";
        }

        public String foo(Integer i, String ... s) {
            return "foo(int, String...)";
        }

        public String foo(long l) {
            return "foo(long)";
        }

        public String foo(long ... l) {
            return "foo(long...)";
        }

        public String foo(Object o) {
            return "foo(Object)";
        }

        public String foo(Object ... s) {
            return "foo(Object...)";
        }

        public String foo(String s) {
            return "foo(String)";
        }

        public String foo(String ... s) {
            return "foo(String...)";
        }

        public void oneParameter(String s) {
        }

        private String privateStringStuff() {
            return "privateStringStuff()";
        }

        private String privateStringStuff(double d) {
            return "privateStringStuff(double)";
        }

        private String privateStringStuff(int i) {
            return "privateStringStuff(int)";
        }

        private String privateStringStuff(Integer i) {
            return "privateStringStuff(Integer)";
        }

        private String privateStringStuff(Object s) {
            return "privateStringStuff(Object)";
        }

        private String privateStringStuff(String s) {
            return "privateStringStuff(String)";
        }

        private void privateStuff() {
        }

        public int[] unboxing(int ... values) {
            return values;
        }

        public ImmutablePair<String, Object[]> varOverloadEcho(Number ... args) {
            return new ImmutablePair((Object)"Number...", (Object)args);
        }

        public ImmutablePair<String, Object[]> varOverloadEcho(String ... args) {
            return new ImmutablePair((Object)"String...", (Object)args);
        }
    }

    private static final class TestMutable
    implements Mutable<Object> {
        private TestMutable() {
        }

        public Object getValue() {
            return null;
        }

        public void setValue(Object value) {
        }
    }

    static class TestBeanWithInterfaces
    implements PrivateInterface {
        TestBeanWithInterfaces() {
        }

        public String foo() {
            return "foo()";
        }
    }

    public static class InheritanceBean {
        public void testOne(GrandParentObject obj) {
        }

        public void testOne(Object obj) {
        }

        public void testOne(ParentObject obj) {
        }

        public void testTwo(ChildInterface obj) {
        }

        public void testTwo(GrandParentObject obj) {
        }

        public void testTwo(Object obj) {
        }
    }

    public static class ParentObject
    extends GrandParentObject {
    }

    public static class ChildObject
    extends ParentObject
    implements ChildInterface {
    }

    public static class GrandParentObject {
    }

    static interface ChildInterface {
    }

    private static final class GetMatchingMethodClass {
        private GetMatchingMethodClass() {
        }

        public void testMethod() {
        }

        public void testMethod(long aLong) {
        }

        public void testMethod(Long aLong) {
        }

        public void testMethod2(Color aColor) {
        }

        public void testMethod2(long aLong) {
        }

        public void testMethod2(Long aLong) {
        }

        public void testMethod3(long aLong, Long anotherLong) {
        }

        public void testMethod3(Long aLong, long anotherLong) {
        }

        public void testMethod3(Long aLong, Long anotherLong) {
        }

        public void testMethod4(Color aColor1, Color aColor2) {
        }

        public void testMethod4(Long aLong, Long anotherLong) {
        }
    }

    private static final class GetMatchingMethodImpl
    extends AbstractGetMatchingMethod {
        private GetMatchingMethodImpl() {
        }

        @Override
        public void testMethod5(Exception exception) {
        }
    }

    private static final class MethodDescriptor {
        final Class<?> declaringClass;
        final String name;
        final Type[] parameterTypes;

        MethodDescriptor(Class<?> declaringClass, String name, Type ... parameterTypes) {
            this.declaringClass = declaringClass;
            this.name = name;
            this.parameterTypes = parameterTypes;
        }
    }

    private static interface PrivateInterface {
    }

    static interface InterfaceGetMatchingMethod {
        default public void testMethod6() {
        }
    }

    protected static abstract class AbstractGetMatchingMethod
    implements InterfaceGetMatchingMethod {
        protected AbstractGetMatchingMethod() {
        }

        public abstract void testMethod5(Exception var1);
    }
}

