/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.bytecode;

import org.apache.commons.compress.harmony.unpack200.bytecode.CPDouble;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPFloat;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPInteger;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPLong;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPMember;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPString;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.apache.commons.compress.harmony.unpack200.bytecode.SourceFileAttribute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassFileEntryTest {
    private void checkEquality(Object equal1, Object equal2, String toString, Object unequal) {
        Assertions.assertEquals((Object)equal1, (Object)equal2);
        Assertions.assertEquals((int)equal1.hashCode(), (int)equal2.hashCode());
        Assertions.assertTrue((boolean)equal1.toString().contains(toString));
        Assertions.assertNotEquals((Object)equal1, (Object)unequal);
        Assertions.assertNotEquals((Object)equal2, (Object)unequal);
        Assertions.assertNotEquals((Object)unequal, (Object)equal1);
        Assertions.assertNotEquals((Object)unequal, (Object)equal2);
    }

    @Test
    public void testCPDouble() {
        CPDouble cp1 = new CPDouble(Double.valueOf(3.0), 3);
        CPDouble cp2 = new CPDouble(Double.valueOf(3.0), 3);
        CPDouble cp3 = new CPDouble(Double.valueOf(5.0), 5);
        this.checkEquality(cp1, cp2, "3", cp3);
    }

    @Test
    public void testCPField() {
        CPMember cp1 = new CPMember(new CPUTF8("Name", 3), new CPUTF8("I", 4), 0L, null);
        CPMember cp2 = new CPMember(new CPUTF8("Name", 3), new CPUTF8("I", 4), 0L, null);
        CPMember cp3 = new CPMember(new CPUTF8("Name", 3), new CPUTF8("Z", 5), 0L, null);
        CPMember cp4 = new CPMember(new CPUTF8("GName", 6), new CPUTF8("I", 4), 0L, null);
        this.checkEquality(cp1, cp2, "Name", cp3);
        this.checkEquality(cp1, cp2, "I", cp4);
    }

    @Test
    public void testCPFloat() {
        CPFloat cp1 = new CPFloat(Float.valueOf(3.0f), 3);
        CPFloat cp2 = new CPFloat(Float.valueOf(3.0f), 3);
        CPFloat cp3 = new CPFloat(Float.valueOf(5.0f), 5);
        this.checkEquality(cp1, cp2, "3", cp3);
    }

    @Test
    public void testCPInteger() {
        CPInteger cp1 = new CPInteger(Integer.valueOf(3), 3);
        CPInteger cp2 = new CPInteger(Integer.valueOf(3), 3);
        CPInteger cp3 = new CPInteger(Integer.valueOf(5), 5);
        this.checkEquality(cp1, cp2, "3", cp3);
    }

    @Test
    public void testCPLong() {
        CPLong cp1 = new CPLong(Long.valueOf(3L), 3);
        CPLong cp2 = new CPLong(Long.valueOf(3L), 3);
        CPLong cp3 = new CPLong(Long.valueOf(5L), 5);
        this.checkEquality(cp1, cp2, "3", cp3);
    }

    @Test
    public void testCPString() {
        CPString cp1 = new CPString(new CPUTF8("3", 3), 3);
        CPString cp2 = new CPString(new CPUTF8("3", 3), 3);
        CPString cp3 = new CPString(new CPUTF8("5", 5), 5);
        this.checkEquality(cp1, cp2, "3", cp3);
    }

    @Test
    public void testSourceAttribute() {
        SourceFileAttribute sfa1 = new SourceFileAttribute(new CPUTF8("Thing.java", 1));
        SourceFileAttribute sfa2 = new SourceFileAttribute(new CPUTF8("Thing.java", 1));
        SourceFileAttribute sfa3 = new SourceFileAttribute(new CPUTF8("OtherThing.java", 2));
        this.checkEquality(sfa1, sfa2, "Thing.java", sfa3);
    }

    @Test
    public void testUTF8() {
        CPUTF8 u1 = new CPUTF8("thing", 1);
        CPUTF8 u2 = new CPUTF8("thing", 1);
        CPUTF8 u3 = new CPUTF8("otherthing", 2);
        this.checkEquality(u1, u2, "thing", u3);
    }
}

