/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.harmony.pack200.BHSDCodec;
import org.apache.commons.compress.harmony.pack200.Codec;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.unpack200.AbstractBandsTest;
import org.apache.commons.compress.harmony.unpack200.ClassBands;
import org.apache.commons.compress.harmony.unpack200.CpBands;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassBandsTest
extends AbstractBandsTest {
    private String[] cpClasses;
    private String[] cpDescriptor;
    private String[] cpUTF8;
    ClassBands classBands = new ClassBands((Segment)new MockSegment());

    private byte[] encodeBandInt(int[] data, BHSDCodec codec) throws IOException, Pack200Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < data.length; ++i) {
            baos.write(codec.encode(data[i], i == 0 ? 0 : data[i - 1]));
        }
        return baos.toByteArray();
    }

    @Test
    public void testSimple() throws IOException, Pack200Exception {
        this.cpClasses = new String[]{"Class1", "Class2", "Class3", "Interface1", "Interface2"};
        this.cpDescriptor = new String[0];
        this.cpUTF8 = new String[0];
        byte[] classThis = Codec.DELTA5.encode(1, 0);
        byte[] classSuper = Codec.DELTA5.encode(2, 0);
        byte[] classInterfaceCount = Codec.DELTA5.encode(2, 0);
        byte[] classInterfaceRef1 = this.encodeBandInt(new int[]{3, 4}, Codec.DELTA5);
        byte[] classFieldCount = Codec.DELTA5.encode(0, 0);
        byte[] classMethodCount = Codec.DELTA5.encode(0, 0);
        byte[] classFlags = Codec.UNSIGNED5.encode(0, 0);
        byte[][] allArrays = new byte[][]{classThis, classSuper, classInterfaceCount, classInterfaceRef1, classFieldCount, classMethodCount, classFlags};
        int total = classThis.length + classSuper.length + classInterfaceCount.length + classInterfaceRef1.length + classFieldCount.length + classMethodCount.length + classFlags.length;
        byte[] bytes = new byte[total];
        int index = 0;
        byte[][] byArrayArray = allArrays;
        int n = byArrayArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] array;
            byte[] byArray = array = byArrayArray[i];
            int n2 = byArray.length;
            for (int j = 0; j < n2; ++j) {
                byte element;
                bytes[index] = element = byArray[j];
                ++index;
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.classBands.unpack((InputStream)in);
        Assertions.assertEquals((int)1, (int)this.classBands.getClassThisInts()[0]);
        Assertions.assertEquals((int)2, (int)this.classBands.getClassSuperInts()[0]);
        Assertions.assertEquals((int)1, (int)this.classBands.getClassInterfacesInts().length);
        Assertions.assertEquals((int)2, (int)this.classBands.getClassInterfacesInts()[0].length);
        Assertions.assertEquals((int)3, (int)this.classBands.getClassInterfacesInts()[0][0]);
        Assertions.assertEquals((int)4, (int)this.classBands.getClassInterfacesInts()[0][1]);
        this.cpClasses = null;
    }

    @Test
    public void testWithMethods() throws Pack200Exception, IOException {
        this.cpClasses = new String[]{"Class1", "Class2", "Class3"};
        this.cpDescriptor = new String[]{"method1", "method2", "method3"};
        this.cpUTF8 = new String[0];
        byte[] classThis = Codec.DELTA5.encode(1, 0);
        byte[] classSuper = Codec.DELTA5.encode(2, 0);
        byte[] classInterfaceCount = Codec.DELTA5.encode(0, 0);
        byte[] classFieldCount = Codec.DELTA5.encode(0, 0);
        byte[] classMethodCount = Codec.DELTA5.encode(3, 0);
        byte[] methodDescr = this.encodeBandInt(new int[]{0, 1, 2}, Codec.MDELTA5);
        byte[] methodFlagsLo = this.encodeBandInt(new int[]{0, 0, 0}, Codec.UNSIGNED5);
        byte[] classFlags = Codec.UNSIGNED5.encode(0, 0);
        byte[][] allArrays = new byte[][]{classThis, classSuper, classInterfaceCount, classFieldCount, classMethodCount, methodDescr, methodFlagsLo, classFlags};
        int total = 0;
        for (byte[] array : allArrays) {
            total += array.length;
        }
        byte[] bytes = new byte[total];
        int index = 0;
        byte[][] byArrayArray = allArrays;
        int n = byArrayArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] array;
            byte[] byArray = array = byArrayArray[i];
            int n2 = byArray.length;
            for (int j = 0; j < n2; ++j) {
                byte element;
                bytes[index] = element = byArray[j];
                ++index;
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.classBands.unpack((InputStream)in);
        Assertions.assertEquals((int)1, (int)this.classBands.getClassThisInts()[0]);
        Assertions.assertEquals((int)2, (int)this.classBands.getClassSuperInts()[0]);
        Assertions.assertEquals((int)1, (int)this.classBands.getMethodDescr().length);
        Assertions.assertEquals((int)3, (int)this.classBands.getMethodDescr()[0].length);
        Assertions.assertEquals((Object)this.cpDescriptor[0], (Object)this.classBands.getMethodDescr()[0][0]);
        Assertions.assertEquals((Object)this.cpDescriptor[1], (Object)this.classBands.getMethodDescr()[0][1]);
        Assertions.assertEquals((Object)this.cpDescriptor[2], (Object)this.classBands.getMethodDescr()[0][2]);
        this.cpClasses = null;
        this.cpDescriptor = null;
    }

    public class MockSegment
    extends AbstractBandsTest.MockSegment {
        protected CpBands getCpBands() {
            return new MockCpBands(this);
        }
    }

    public class MockCpBands
    extends CpBands {
        public MockCpBands(Segment segment) {
            super(segment);
        }

        public String[] getCpClass() {
            return ClassBandsTest.this.cpClasses;
        }

        public String[] getCpDescriptor() {
            return ClassBandsTest.this.cpDescriptor;
        }

        public double[] getCpDouble() {
            return new double[0];
        }

        public float[] getCpFloat() {
            return new float[0];
        }

        public int[] getCpInt() {
            return new int[0];
        }

        public long[] getCpLong() {
            return new long[0];
        }

        public String[] getCpSignature() {
            return new String[0];
        }

        public String[] getCpUTF8() {
            return ClassBandsTest.this.cpUTF8;
        }
    }
}

