/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class XZTest
extends AbstractTest {
    @Test
    public void testConcatenatedStreamsReadFirstOnly() throws Exception {
        File input = XZTest.getFile("multiple.xz");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("xz", is);){
            Assertions.assertEquals((int)97, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testConcatenatedStreamsReadFully() throws Exception {
        File input = XZTest.getFile("multiple.xz");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             XZCompressorInputStream in = new XZCompressorInputStream(is, true);){
            Assertions.assertEquals((int)97, (int)in.read());
            Assertions.assertEquals((int)98, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.available());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testXZCreation() throws Exception {
        long max = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        System.out.println("XZTestCase: HeapMax=" + max + " bytes " + (double)max / 1048576.0 + " MB");
        File input = XZTest.getFile("test1.xml");
        File output = this.newTempFile("test1.xml.xz");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("xz", out);){
            Files.copy(input.toPath(), (OutputStream)cos);
        }
    }

    @Test
    public void testXZUnarchive() throws Exception {
        File input = XZTest.getFile("bla.tar.xz");
        File output = this.newTempFile("bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("xz", is);){
            Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
        }
    }
}

