/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.EjbqlQueryPropertiesPanel;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.project.extension.info.ObjectInfo;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class EjbqlQueryMainTab
extends JPanel {
    protected ProjectController mediator;
    protected TextAdapter name;
    protected TextAdapter comment;
    protected EjbqlQueryPropertiesPanel properties;
    protected TextAdapter qualifier;

    public EjbqlQueryMainTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                EjbqlQueryMainTab.this.setQueryName(text);
            }
        };
        this.comment = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                EjbqlQueryMainTab.this.setQueryComment(text);
            }
        };
        this.properties = new EjbqlQueryPropertiesPanel(this.mediator);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, fill:max(200dlu;pref)", "p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("EJBQL Query Settings", cc.xywh(1, 1, 3, 1));
        builder.addLabel("Query Name:", cc.xy(1, 3));
        builder.add((Component)this.name.getComponent(), cc.xy(3, 3));
        builder.addLabel("Comment:", cc.xy(1, 5));
        builder.add((Component)this.comment.getComponent(), cc.xy(3, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "North");
        this.add((Component)this.properties, "Center");
    }

    void initFromModel() {
        QueryDescriptor query = this.mediator.getCurrentQuery();
        if (query == null || !"EJBQLQuery".equals(query.getType())) {
            this.setVisible(false);
            return;
        }
        this.name.setText(query.getName());
        this.comment.setText(this.getQueryComment(query));
        this.properties.initFromModel(query);
        this.setVisible(true);
    }

    protected QueryDescriptor getQuery() {
        QueryDescriptor query = this.mediator.getCurrentQuery();
        return query != null && "EJBQLQuery".equals(query.getType()) ? query : null;
    }

    void setQueryName(String newName) {
        QueryDescriptor query;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((query = this.getQuery()) == null) {
            return;
        }
        if (Util.nullSafeEquals(newName, query.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Query name is required.", new Object[0]);
        }
        DataMap map = this.mediator.getCurrentDataMap();
        if (map.getQueryDescriptor(newName) != null) {
            throw new ValidationException("There is another query named '" + newName + "'. Use a different name.", new Object[0]);
        }
        QueryEvent e = new QueryEvent((Object)this, query, query.getName());
        ProjectUtil.setQueryName(map, query, newName);
        this.mediator.fireQueryEvent(e);
    }

    private void setQueryComment(String text) {
        QueryDescriptor query = this.getQuery();
        if (query == null) {
            return;
        }
        ObjectInfo.putToMetaData(this.mediator.getApplication().getMetaData(), query, "comment", text);
        this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
    }

    private String getQueryComment(QueryDescriptor queryDescriptor) {
        return ObjectInfo.getFromMetaData(this.mediator.getApplication().getMetaData(), queryDescriptor, "comment");
    }
}

