/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authentication;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;

public class CertificateCredentials
implements Credentials {
    private final List<Certificate> certificateChain;
    private final X509Certificate peerCertificate;

    public CertificateCredentials(Certificate certificate) {
        this(Collections.singletonList(certificate));
    }

    public CertificateCredentials(List<Certificate> certificateChain) {
        this.certificateChain = Collections.unmodifiableList(certificateChain);
        this.peerCertificate = this.getPeerCertificate();
    }

    public static CertificateCredentials fromHttpRequest(HttpServerRequest request) {
        try {
            return new CertificateCredentials(request.connection().peerCertificates());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not extract certificates from request", e);
        }
    }

    public List<Certificate> certificateChain() {
        return this.certificateChain;
    }

    public X509Certificate peerCertificate() {
        return this.peerCertificate;
    }

    public void checkValid() throws CredentialValidationException {
        this.checkValid(null);
    }

    public <V> void checkValid(V arg) throws CredentialValidationException {
        if (this.certificateChain.isEmpty()) {
            throw new CredentialValidationException("Certificate Chain cannot be empty");
        }
    }

    public JsonObject toJson() {
        throw new UnsupportedOperationException("Deprecated authentication method");
    }

    private X509Certificate getPeerCertificate() {
        if (!this.certificateChain.isEmpty() && this.certificateChain.get(0) instanceof X509Certificate) {
            return (X509Certificate)this.certificateChain.get(0);
        }
        return null;
    }
}

