/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes.validations;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.TableMetadata;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.routes.AbstractHandler;
import org.apache.cassandra.sidecar.routes.RoutingContextUtils;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class ValidateTableExistenceHandler
extends AbstractHandler<QualifiedTableName> {
    @Inject
    public ValidateTableExistenceHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator) {
        super(metadataFetcher, executorPools, validator);
    }

    @Override
    protected QualifiedTableName extractParamsOrThrow(RoutingContext context) {
        return this.qualifiedTableName(context, false);
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, QualifiedTableName input) {
        if (input.keyspace() == null) {
            context.next();
            return;
        }
        this.getKeyspaceMetadata(host, input.keyspace()).onFailure(arg_0 -> ((RoutingContext)context).fail(arg_0)).onSuccess(keyspaceMetadata -> {
            if (keyspaceMetadata == null) {
                context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, "Keyspace " + input.keyspace() + " was not found"));
                return;
            }
            RoutingContextUtils.put(context, RoutingContextUtils.SC_KEYSPACE_METADATA, keyspaceMetadata);
            String table = input.tableName();
            if (table == null) {
                context.next();
                return;
            }
            TableMetadata tableMetadata = keyspaceMetadata.getTable(table);
            if (tableMetadata == null) {
                String errMsg = "Table " + input.tableName() + " was not found for keyspace " + input.keyspace();
                context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, errMsg));
            } else {
                RoutingContextUtils.put(context, RoutingContextUtils.SC_TABLE_METADATA, tableMetadata);
                context.next();
            }
        });
    }

    private Future<KeyspaceMetadata> getKeyspaceMetadata(String host, String keyspace) {
        return this.executorPools.service().executeBlocking(() -> this.metadataFetcher.instance(host).delegate().metadata().getKeyspace(keyspace));
    }
}

