/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes.data;

import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.utils.RequestUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class StreamSSTableComponentRequestParam {
    private final String tableId;
    private final String snapshotName;
    private final int dataDirectoryIndex;
    private final QualifiedTableName qualifiedTableName;
    private final String componentName;
    @Nullable
    private final String secondaryIndexName;

    @VisibleForTesting
    public StreamSSTableComponentRequestParam(String keyspace, String tableName, String snapshotName, String componentName) {
        this(new QualifiedTableName(keyspace, tableName, true), snapshotName, null, componentName, null, 0);
    }

    public StreamSSTableComponentRequestParam(QualifiedTableName qualifiedTableName, String snapshotName, @Nullable String secondaryIndexName, String componentName, @Nullable String tableId, int dataDirectoryIndex) {
        this.qualifiedTableName = Objects.requireNonNull(qualifiedTableName, "qualifiedTableName must not be null");
        this.secondaryIndexName = secondaryIndexName;
        this.componentName = Objects.requireNonNull(componentName, "componentName must not be null");
        this.snapshotName = Objects.requireNonNull(snapshotName, "snapshotName must not be null");
        this.tableId = tableId;
        this.dataDirectoryIndex = dataDirectoryIndex;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String tableId() {
        return this.tableId;
    }

    public int dataDirectoryIndex() {
        return this.dataDirectoryIndex;
    }

    public String toString() {
        return "StreamSSTableComponentRequest{keyspace='" + this.keyspace() + "', tableName='" + this.tableName() + "', snapshot='" + this.snapshotName + "', secondaryIndexName='" + this.secondaryIndexName() + "', componentName='" + this.componentName() + "', dataDirectoryIndex='" + this.dataDirectoryIndex + "'}";
    }

    public static StreamSSTableComponentRequestParam from(QualifiedTableName qualifiedTableName, RoutingContext context) {
        String snapshotName = context.pathParam("snapshot");
        String secondaryIndexName = context.pathParam("index");
        String componentName = context.pathParam("component");
        String tableId = StreamSSTableComponentRequestParam.maybeGetTableId(context.pathParam("table"));
        int dataDirectoryIndex = RequestUtils.parseIntegerQueryParam(context.request(), "dataDirectoryIndex", 0);
        return new StreamSSTableComponentRequestParam(qualifiedTableName, snapshotName, secondaryIndexName, componentName, tableId, dataDirectoryIndex);
    }

    static String maybeGetTableId(String table) {
        int index;
        if (table != null && (index = table.indexOf("-")) > 0 && index + 1 < table.length()) {
            return table.substring(index + 1);
        }
        return null;
    }

    public QualifiedTableName qualifiedTableName() {
        return this.qualifiedTableName;
    }

    public String keyspace() {
        return this.qualifiedTableName.keyspace();
    }

    public String tableName() {
        return this.qualifiedTableName.tableName();
    }

    @Nullable
    public String secondaryIndexName() {
        return this.secondaryIndexName;
    }

    public String componentName() {
        return this.componentName;
    }
}

