/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes.data;

import java.util.Objects;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;

public class SnapshotRequestParam {
    private final String snapshotName;
    private final boolean includeSecondaryIndexFiles;
    private final QualifiedTableName qualifiedTableName;
    private final String ttl;

    private SnapshotRequestParam(Builder builder) {
        this.snapshotName = Objects.requireNonNull(builder.snapshotName, "snapshotName must not be null");
        this.qualifiedTableName = Objects.requireNonNull(builder.qualifiedTableName, "qualifiedTableName must be not null");
        this.includeSecondaryIndexFiles = builder.includeSecondaryIndexFiles;
        this.ttl = builder.ttl;
    }

    public QualifiedTableName qualifiedTableName() {
        return this.qualifiedTableName;
    }

    public String keyspace() {
        return this.qualifiedTableName.keyspace();
    }

    public String tableName() {
        return this.qualifiedTableName.tableName();
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public boolean includeSecondaryIndexFiles() {
        return this.includeSecondaryIndexFiles;
    }

    public String ttl() {
        return this.ttl;
    }

    public String toString() {
        return "SnapshotRequest{keyspace='" + this.keyspace() + "', tableName='" + this.tableName() + "', snapshotName='" + this.snapshotName + "', includeSecondaryIndexFiles=" + this.includeSecondaryIndexFiles + ", ttl=" + this.ttl + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements DataObjectBuilder<Builder, SnapshotRequestParam> {
        private String snapshotName;
        private boolean includeSecondaryIndexFiles = false;
        private QualifiedTableName qualifiedTableName;
        private String ttl;

        private Builder() {
        }

        public Builder self() {
            return this;
        }

        public Builder snapshotName(String snapshotName) {
            return (Builder)this.update(b -> {
                b.snapshotName = snapshotName;
            });
        }

        public Builder includeSecondaryIndexFiles(boolean includeSecondaryIndexFiles) {
            return (Builder)this.update(b -> {
                b.includeSecondaryIndexFiles = includeSecondaryIndexFiles;
            });
        }

        public Builder qualifiedTableName(String keyspace, String table) {
            return (Builder)this.update(b -> {
                b.qualifiedTableName = new QualifiedTableName(keyspace, table);
            });
        }

        public Builder qualifiedTableName(QualifiedTableName qualifiedTableName) {
            return (Builder)this.update(b -> {
                b.qualifiedTableName = qualifiedTableName;
            });
        }

        public Builder ttl(String ttl) {
            return (Builder)this.update(b -> {
                b.ttl = ttl;
            });
        }

        public SnapshotRequestParam build() {
            return new SnapshotRequestParam(this);
        }
    }
}

