/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes.cdc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.response.ListCdcSegmentsResponse;
import org.apache.cassandra.sidecar.common.response.data.CdcSegmentInfo;
import org.apache.cassandra.sidecar.common.utils.StringUtils;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.routes.AbstractHandler;
import org.apache.cassandra.sidecar.routes.AccessProtected;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.CdcUtil;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ListCdcDirHandler
extends AbstractHandler<Void>
implements AccessProtected {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListCdcDirHandler.class);
    private final ServiceConfiguration config;
    private final TaskExecutorPool serviceExecutorPool;

    @Inject
    public ListCdcDirHandler(InstanceMetadataFetcher metadataFetcher, SidecarConfiguration config, ExecutorPools executorPools, CassandraInputValidator validator) {
        super(metadataFetcher, executorPools, validator);
        this.config = config.serviceConfiguration();
        this.serviceExecutorPool = executorPools.service();
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.CDC.toAuthorization());
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, Void request) {
        String cdcDir = this.metadataFetcher.instance(host).cdcDir();
        if (StringUtils.isNullOrEmpty((String)cdcDir)) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.SERVICE_UNAVAILABLE, "CDC directory is not configured in Sidecar");
        }
        this.serviceExecutorPool.executeBlocking(() -> this.collectCdcSegmentsFromFileSystem(cdcDir)).map(segments -> new ListCdcSegmentsResponse(this.config.host(), this.config.port(), segments)).onSuccess(arg_0 -> ((RoutingContext)context).json(arg_0)).onFailure(cause -> {
            LOGGER.warn("Error listing the CDC commit log segments", cause);
            context.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setStatusMessage(Objects.requireNonNullElse(cause.getMessage(), "Error while listing CDC segments")).end();
        });
    }

    private List<CdcSegmentInfo> collectCdcSegmentsFromFileSystem(String cdcDirPath) throws IOException {
        ArrayList<CdcSegmentInfo> segmentInfos = new ArrayList<CdcSegmentInfo>();
        File cdcDir = Paths.get(cdcDirPath, new String[0]).toAbsolutePath().toFile();
        if (!cdcDir.isDirectory()) {
            throw new IOException("CDC directory does not exist");
        }
        File[] cdcFiles = cdcDir.listFiles();
        if (cdcFiles == null || cdcFiles.length == 0) {
            return segmentInfos;
        }
        HashSet<String> idxFileNamePrefixes = new HashSet<String>();
        for (File cdcFile : cdcFiles) {
            if (!CdcUtil.matchIndexExtension(cdcFile.getName())) continue;
            idxFileNamePrefixes.add(CdcUtil.getIdxFilePrefix(cdcFile.getName()));
        }
        for (File cdcFile : cdcFiles) {
            String fileName = cdcFile.getName();
            BasicFileAttributes fileAttributes = Files.readAttributes(cdcFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (!cdcFile.exists() || !fileAttributes.isRegularFile() || CdcUtil.isIndexFile(fileName) || !idxFileNamePrefixes.contains(CdcUtil.getLogFilePrefix(fileName))) continue;
            CdcUtil.CdcIndex cdcIndex = CdcUtil.parseIndexFile(new File(cdcDirPath, CdcUtil.getIdxFileName(fileName)), fileAttributes.size());
            CdcSegmentInfo segmentInfo = new CdcSegmentInfo(fileName, fileAttributes.size(), cdcIndex.latestFlushPosition, cdcIndex.isCompleted, fileAttributes.lastModifiedTime().toMillis());
            segmentInfos.add(segmentInfo);
        }
        return segmentInfos;
    }

    @Override
    protected Void extractParamsOrThrow(RoutingContext context) {
        return null;
    }
}

