/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.routes.AbstractHandler;
import org.apache.cassandra.sidecar.routes.AccessProtected;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Singleton
public class KeyspaceRingHandler
extends AbstractHandler<Name>
implements AccessProtected {
    @Inject
    public KeyspaceRingHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator) {
        super(metadataFetcher, executorPools, validator);
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.READ_RING_KEYSPACE_SCOPED.toAuthorization());
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, Name keyspace) {
        StorageOperations operations = this.metadataFetcher.delegate(host).storageOperations();
        this.executorPools.service().executeBlocking(() -> operations.ring(keyspace)).onSuccess(arg_0 -> ((RoutingContext)context).json(arg_0)).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, keyspace));
    }

    @Override
    protected void processFailure(Throwable cause, RoutingContext context, String host, SocketAddress remoteAddress, Name keyspace) {
        if (cause instanceof IllegalArgumentException && StringUtils.contains((CharSequence)cause.getMessage(), (CharSequence)", does not exist")) {
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, cause.getMessage(), cause));
            return;
        }
        super.processFailure(cause, context, host, remoteAddress, keyspace);
    }

    @Override
    protected Name extractParamsOrThrow(RoutingContext context) {
        return this.keyspace(context, true);
    }
}

