/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.common.WebEnvironment;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.handler.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonErrorHandler
implements ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonErrorHandler.class);
    private final boolean displayExceptionDetails;

    public JsonErrorHandler() {
        this(WebEnvironment.development());
    }

    public JsonErrorHandler(boolean displayExceptionDetails) {
        this.displayExceptionDetails = displayExceptionDetails;
    }

    public void handle(RoutingContext ctx) {
        Throwable t = ctx.failure();
        if (t instanceof HttpException) {
            this.handleHttpException(ctx, (HttpException)t);
        } else if (ctx.statusCode() == HttpResponseStatus.REQUEST_TIMEOUT.code()) {
            this.handleRequestTimeout(ctx);
        } else {
            this.handleThrowable(ctx, t);
        }
    }

    private void handleHttpException(RoutingContext ctx, HttpException httpException) {
        JsonObject payload = new JsonObject().put("status", (Object)httpException.getMessage()).put("code", (Object)httpException.getStatusCode()).put("message", (Object)httpException.getPayload());
        this.writeResponse(ctx, httpException.getStatusCode(), payload);
    }

    private void handleRequestTimeout(RoutingContext ctx) {
        JsonObject payload = new JsonObject().put("status", (Object)"Request Timeout");
        this.writeResponse(ctx, HttpResponseStatus.REQUEST_TIMEOUT.code(), payload);
    }

    private void handleThrowable(RoutingContext ctx, Throwable exception) {
        int effectiveStatusCode = ctx.statusCode() != 200 ? ctx.statusCode() : HttpResponseStatus.INTERNAL_SERVER_ERROR.code();
        HttpResponseStatus responseStatus = HttpResponseStatus.valueOf((int)effectiveStatusCode);
        JsonObject payload = new JsonObject().put("status", (Object)responseStatus.reasonPhrase());
        if (this.displayExceptionDetails) {
            payload.put("code", (Object)effectiveStatusCode);
            if (exception != null) {
                JsonArray stack = new JsonArray();
                for (StackTraceElement elem : exception.getStackTrace()) {
                    stack.add((Object)elem.toString());
                }
                payload.put("message", (Object)exception.getMessage()).put("stack", (Object)stack);
            } else {
                payload.put("message", (Object)responseStatus.reasonPhrase());
            }
        }
        this.writeResponse(ctx, responseStatus.code(), payload);
        LOGGER.error("Exception effectiveStatusCode={}", (Object)effectiveStatusCode, (Object)exception);
    }

    private void writeResponse(RoutingContext ctx, int statusCode, JsonObject payload) {
        HttpServerResponse response = ctx.response();
        if (!response.ended() && !response.closed()) {
            response.setStatusCode(statusCode).putHeader(HttpHeaders.CONTENT_TYPE.toString(), "application/json").end(payload.encode());
        }
    }
}

