/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.server.utils.ThrowableUtils;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.models.HttpResponse;
import org.apache.cassandra.sidecar.routes.AbstractHandler;
import org.apache.cassandra.sidecar.utils.FileStreamer;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class FileStreamHandler
extends AbstractHandler<String> {
    public static final String FILE_PATH_CONTEXT_KEY = "fileToTransfer";
    private final FileStreamer fileStreamer;

    @Inject
    public FileStreamHandler(InstanceMetadataFetcher metadataFetcher, FileStreamer fileStreamer, ExecutorPools executorPools) {
        super(metadataFetcher, executorPools, null);
        this.fileStreamer = fileStreamer;
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, String localFile) {
        InstanceMetadata instanceMetadata = this.metadataFetcher.instance(host);
        this.fileSize(context, localFile).compose(fileSize -> this.fileStreamer.stream(new HttpResponse(httpRequest, context.response()), instanceMetadata.id(), localFile, (long)fileSize, httpRequest.getHeader((CharSequence)HttpHeaderNames.RANGE))).onSuccess(v -> this.logger.debug("Completed streaming file '{}'", (Object)localFile)).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, localFile));
    }

    @Override
    protected String extractParamsOrThrow(RoutingContext context) {
        return (String)context.get(FILE_PATH_CONTEXT_KEY);
    }

    @Override
    protected void processFailure(Throwable cause, RoutingContext context, String host, SocketAddress remoteAddress, String localFile) {
        IOException fileNotFoundException = (IOException)ThrowableUtils.getCause((Throwable)cause, NoSuchFileException.class);
        if (fileNotFoundException == null) {
            fileNotFoundException = (IOException)ThrowableUtils.getCause((Throwable)cause, FileNotFoundException.class);
        }
        if (fileNotFoundException != null) {
            this.logger.error("The requested file '{}' does not exist", (Object)localFile);
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, "The requested file does not exist"));
            return;
        }
        super.processFailure(cause, context, host, remoteAddress, localFile);
    }

    protected Future<Long> fileSize(RoutingContext context, String path) {
        return context.vertx().fileSystem().props(path).compose(fileProps -> {
            if (fileProps == null || !fileProps.isRegularFile()) {
                this.logger.error("The requested file '{}' does not exist", (Object)path);
                return Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, "The requested file does not exist"));
            }
            if (fileProps.size() <= 0L) {
                this.logger.error("The requested file '{}' has 0 size", (Object)path);
                return Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE, "The requested file is empty"));
            }
            return Future.succeededFuture((Object)fileProps.size());
        });
    }
}

