/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.Json;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import org.apache.cassandra.sidecar.cluster.CassandraAdapterDelegate;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.routes.AbstractHandler;
import org.apache.cassandra.sidecar.server.MainModule;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class CassandraHealthHandler
extends AbstractHandler<Void> {
    @Inject
    protected CassandraHealthHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator) {
        super(metadataFetcher, executorPools, validator);
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, Void request) {
        boolean isServiceUp;
        CassandraAdapterDelegate delegate = this.metadataFetcher.delegate(host);
        boolean bl = isServiceUp = context.request().path().contains("/jmx") ? delegate.isJmxUp() : delegate.isNativeUp();
        if (isServiceUp) {
            context.json(MainModule.OK_STATUS);
        } else {
            context.response().setStatusCode(HttpResponseStatus.SERVICE_UNAVAILABLE.code()).putHeader(HttpHeaders.CONTENT_TYPE.toString(), "application/json").end(Json.CODEC.toString(MainModule.NOT_OK_STATUS, false));
        }
    }

    @Override
    protected Void extractParamsOrThrow(RoutingContext context) {
        return null;
    }
}

