/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.auth.authorization.AndAuthorization;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.acl.authorization.AdminIdentityResolver;
import org.apache.cassandra.sidecar.acl.authorization.AuthorizationParameterValidateHandler;
import org.apache.cassandra.sidecar.acl.authorization.AuthorizationWithAdminBypassHandler;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.config.AccessControlConfiguration;
import org.apache.cassandra.sidecar.exceptions.ConfigurationException;
import org.apache.cassandra.sidecar.routes.AccessProtected;
import org.apache.cassandra.sidecar.routes.RoutingContextUtils;

public class AccessProtectedRouteBuilder {
    private final AccessControlConfiguration accessControlConfiguration;
    private final AuthorizationProvider authorizationProvider;
    private final AdminIdentityResolver adminIdentityResolver;
    private final AuthorizationParameterValidateHandler authZParameterValidateHandler;
    private Router router;
    private HttpMethod method;
    private String endpoint;
    private boolean setBodyHandler;
    private final List<Handler<RoutingContext>> handlers = new ArrayList<Handler<RoutingContext>>();

    public AccessProtectedRouteBuilder(AccessControlConfiguration accessControlConfiguration, AuthorizationProvider authorizationProvider, AdminIdentityResolver adminIdentityResolver, AuthorizationParameterValidateHandler authZParameterValidateHandler) {
        this.accessControlConfiguration = accessControlConfiguration;
        this.authorizationProvider = authorizationProvider;
        this.adminIdentityResolver = adminIdentityResolver;
        this.authZParameterValidateHandler = authZParameterValidateHandler;
    }

    public AccessProtectedRouteBuilder router(Router router) {
        this.router = router;
        return this;
    }

    public AccessProtectedRouteBuilder method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public AccessProtectedRouteBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public AccessProtectedRouteBuilder setBodyHandler(Boolean setBodyHandler) {
        this.setBodyHandler = setBodyHandler;
        return this;
    }

    public AccessProtectedRouteBuilder handler(Handler<RoutingContext> handler) {
        this.handlers.add(handler);
        return this;
    }

    public void build() {
        Objects.requireNonNull(this.router, "Router must be set");
        Objects.requireNonNull(this.method, "Http method must be set");
        Preconditions.checkArgument((this.endpoint != null && !this.endpoint.isEmpty() ? 1 : 0) != 0, (String)"Endpoint must be set");
        Preconditions.checkArgument((!this.handlers.isEmpty() ? 1 : 0) != 0, (String)"Handler chain can not be empty");
        Route route = this.router.route(this.method, this.endpoint);
        if (this.setBodyHandler) {
            route.handler((Handler)BodyHandler.create());
        }
        if (this.accessControlConfiguration.enabled()) {
            AuthorizationWithAdminBypassHandler authorizationHandler = new AuthorizationWithAdminBypassHandler(this.authZParameterValidateHandler, this.adminIdentityResolver, this.requiredAuthorization());
            authorizationHandler.addAuthorizationProvider(this.authorizationProvider);
            authorizationHandler.variableConsumer(this.routeGenericVariableConsumer());
            route.handler((Handler)authorizationHandler);
        }
        this.handlers.forEach(arg_0 -> ((Route)route).handler(arg_0));
    }

    private Authorization requiredAuthorization() {
        Set<Authorization> requiredAuthorizations = this.handlers.stream().filter(handler -> handler instanceof AccessProtected).map(handler -> (AccessProtected)handler).flatMap(handler -> handler.requiredAuthorizations().stream()).collect(Collectors.toSet());
        if (requiredAuthorizations.isEmpty()) {
            throw new ConfigurationException("Authorized route must have authorizations declared");
        }
        AndAuthorization andAuthorization = AndAuthorization.create();
        requiredAuthorizations.forEach(arg_0 -> ((AndAuthorization)andAuthorization).addAuthorization(arg_0));
        return andAuthorization;
    }

    private BiConsumer<RoutingContext, AuthorizationContext> routeGenericVariableConsumer() {
        return (routingCtx, authZContext) -> {
            Optional<QualifiedTableName> optional = RoutingContextUtils.getAsOptional(routingCtx, RoutingContextUtils.SC_QUALIFIED_TABLE_NAME);
            String keyspace = null;
            String table = null;
            if (optional.isPresent()) {
                QualifiedTableName qualifiedTableName = optional.get();
                keyspace = qualifiedTableName.keyspace();
                table = qualifiedTableName.tableName();
            }
            if (keyspace != null) {
                authZContext.variables().add("keyspace", keyspace);
            }
            if (table != null) {
                authZContext.variables().add("table", table);
            }
        };
    }
}

