/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.restore;

import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.db.RestoreRange;
import org.apache.cassandra.sidecar.exceptions.RestoreJobFatalException;
import org.apache.cassandra.sidecar.restore.RestoreProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreJobProgressTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreJobProgressTracker.class);
    private volatile RestoreJob restoreJob;
    private volatile boolean cleanupOutOfRangeRequested = false;
    private final InstanceMetadata instanceMetadata;
    private final Map<RestoreRange, Status> ranges = new ConcurrentHashMap<RestoreRange, Status>();
    private final RestoreProcessor processor;
    private final AtomicReference<RestoreJobFatalException> failureRef = new AtomicReference();

    public RestoreJobProgressTracker(RestoreJob restoreJob, RestoreProcessor restoreProcessor, InstanceMetadata instanceMetadata) {
        this.restoreJob = restoreJob;
        this.processor = restoreProcessor;
        this.instanceMetadata = instanceMetadata;
    }

    Status trySubmit(RestoreRange range) throws RestoreJobFatalException {
        if (this.failureRef.get() != null) {
            throw this.failureRef.get();
        }
        RestoreRange rangeWithTracker = range.unbuild().restoreJobProgressTracker(this).build();
        Status status = this.ranges.putIfAbsent(rangeWithTracker, Status.PENDING);
        if (status == null) {
            this.processor.submit(rangeWithTracker);
            return Status.CREATED;
        }
        return status;
    }

    Set<RestoreRange> discardOverlappingRanges(Set<TokenRange> otherRanges) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        otherRanges.forEach(arg_0 -> RestoreJobProgressTracker.lambda$discardOverlappingRanges$0((RangeSet)rangeSet, arg_0));
        HashSet<RestoreRange> overlapping = new HashSet<RestoreRange>();
        this.ranges.keySet().removeIf(arg_0 -> this.lambda$discardOverlappingRanges$1((RangeSet)rangeSet, overlapping, arg_0));
        return overlapping;
    }

    void updateRestoreJob(@NotNull RestoreJob restoreJob) {
        Objects.requireNonNull(restoreJob, "Cannot nullify restore job");
        this.restoreJob = restoreJob;
    }

    @NotNull
    public RestoreJob restoreJob() {
        return this.restoreJob;
    }

    public void completeRange(RestoreRange range) {
        this.ranges.put(range, Status.COMPLETED);
    }

    public void fail(RestoreJobFatalException exception) {
        boolean applied = this.failureRef.compareAndSet(null, exception);
        if (!applied) {
            LOGGER.debug("The restore job is already failed. Ignoring the exception. jobId={}", (Object)this.restoreJob.jobId, (Object)exception);
            return;
        }
        this.cleanupInternal();
    }

    public boolean isFailed() {
        return this.failureRef.get() != null;
    }

    public void requestOutOfRangeDataCleanup() {
        this.cleanupOutOfRangeRequested = true;
    }

    void cleanupInternal() {
        this.ranges.forEach((range, status) -> {
            if (!this.isFailed() && status != Status.COMPLETED) {
                LOGGER.warn("Clean up pending restore slice when the job has not failed. jobId={}, sliceId={}, startToken={}, endToken={}", new Object[]{this.restoreJob.jobId, range.sliceId(), range.startToken(), range.endToken()});
            }
            range.cancel();
        });
        this.ranges.clear();
        this.runOnCompletion();
    }

    private void runOnCompletion() {
        if (this.cleanupOutOfRangeRequested) {
            try {
                StorageOperations operations = this.instanceMetadata.delegate().storageOperations();
                operations.outOfRangeDataCleanup(this.restoreJob.keyspaceName, this.restoreJob.tableName);
            }
            catch (Throwable cause) {
                LOGGER.warn("Clean up out of range data has failed. jobId={}", (Object)this.restoreJob.jobId, (Object)cause);
            }
        }
    }

    @VisibleForTesting
    Map<RestoreRange, Status> rangesForTesting() {
        return this.ranges;
    }

    private /* synthetic */ boolean lambda$discardOverlappingRanges$1(RangeSet rangeSet, Set overlapping, RestoreRange restoreRange) {
        if (rangeSet.intersects(restoreRange.tokenRange().range)) {
            overlapping.add(restoreRange);
            this.processor.discardAndRemove(restoreRange);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$discardOverlappingRanges$0(RangeSet rangeSet, TokenRange r) {
        rangeSet.add(r.range);
    }

    public static enum Status {
        CREATED,
        PENDING,
        COMPLETED,
        FAILED;

    }
}

