/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.restore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.data.ConsistencyVerificationResult;
import org.apache.cassandra.sidecar.common.data.RestoreJobStatus;
import org.apache.cassandra.sidecar.common.response.data.RestoreJobProgressResponsePayload;
import org.apache.cassandra.sidecar.common.response.data.RestoreRangeJson;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.db.RestoreRange;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class RestoreJobProgress {
    private final RestoreJob restoreJob;
    private final ConsistencyVerificationResult overallStatus;
    private final List<RestoreRange> failedRanges;
    private final List<RestoreRange> pendingRanges;
    private final List<RestoreRange> succeededRanges;

    public static RestoreJobProgress pending(RestoreJob restoreJob) {
        Builder builder = new Builder(restoreJob).withOverallStatus(ConsistencyVerificationResult.PENDING);
        return new RestoreJobProgress(builder);
    }

    private RestoreJobProgress(Builder builder) {
        this.restoreJob = builder.restoreJob;
        this.overallStatus = builder.overallStatus;
        this.failedRanges = builder.failedRanges;
        this.pendingRanges = builder.pendingRanges;
        this.succeededRanges = builder.succeededRanges;
    }

    public RestoreJobProgressResponsePayload toResponsePayload() {
        return RestoreJobProgressResponsePayload.builder().withStatus(this.overallStatus).withSucceededRanges(this.toJson(this.succeededRanges)).withFailedRanges(this.toJson(this.failedRanges)).withPendingRanges(this.toJson(this.pendingRanges)).withMessage(this.buildMessage(this.restoreJob.status)).withJobSummary(this.restoreJob.createdAt.toString(), this.restoreJob.jobId, this.restoreJob.jobAgent, this.restoreJob.keyspaceName, this.restoreJob.tableName, this.restoreJob.status.name()).build();
    }

    @Nullable
    private List<RestoreRangeJson> toJson(List<RestoreRange> ranges) {
        if (ranges == null) {
            return null;
        }
        return ranges.stream().map(RestoreRange::toJson).collect(Collectors.toList());
    }

    private String buildMessage(RestoreJobStatus jobStatus) {
        String message;
        switch (this.overallStatus) {
            case SATISFIED: {
                message = "All ranges have succeeded.";
                break;
            }
            case FAILED: {
                message = "One or more ranges have failed.";
                break;
            }
            default: {
                message = "One or more ranges are in progress. None of the ranges fail.";
            }
        }
        return message + " Current job status: " + jobStatus;
    }

    @VisibleForTesting
    List<RestoreRange> allRanges() {
        ArrayList<RestoreRange> result = new ArrayList<RestoreRange>();
        Consumer<List> addAllIgnoreNull = list -> {
            if (list != null) {
                result.addAll((Collection<RestoreRange>)list);
            }
        };
        addAllIgnoreNull.accept(this.failedRanges);
        addAllIgnoreNull.accept(this.pendingRanges);
        addAllIgnoreNull.accept(this.succeededRanges);
        return result;
    }

    static class Builder
    implements DataObjectBuilder<Builder, RestoreJobProgress> {
        private final RestoreJob restoreJob;
        private ConsistencyVerificationResult overallStatus;
        private List<RestoreRange> failedRanges;
        private List<RestoreRange> pendingRanges;
        private List<RestoreRange> succeededRanges;

        public Builder(RestoreJob restoreJob) {
            this.restoreJob = restoreJob;
        }

        public Builder withOverallStatus(ConsistencyVerificationResult overallStatus) {
            return (Builder)this.update(b -> {
                b.overallStatus = overallStatus;
            });
        }

        public Builder addFailedRange(RestoreRange range) {
            this.failedRanges = this.createIfNull(this.failedRanges);
            return (Builder)this.update(b -> b.failedRanges.add(range));
        }

        public Builder addPendingRange(RestoreRange range) {
            this.pendingRanges = this.createIfNull(this.pendingRanges);
            return (Builder)this.update(b -> b.pendingRanges.add(range));
        }

        public Builder addSucceededRange(RestoreRange range) {
            this.succeededRanges = this.createIfNull(this.succeededRanges);
            return (Builder)this.update(b -> b.succeededRanges.add(range));
        }

        private List<RestoreRange> createIfNull(List<RestoreRange> list) {
            return list == null ? new ArrayList() : list;
        }

        public Builder self() {
            return this;
        }

        public RestoreJobProgress build() {
            return new RestoreJobProgress(this.self());
        }
    }
}

