/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import org.apache.cassandra.sidecar.metrics.CacheMetrics;
import org.apache.cassandra.sidecar.metrics.CoordinationMetrics;
import org.apache.cassandra.sidecar.metrics.HealthMetrics;
import org.apache.cassandra.sidecar.metrics.ResourceMetrics;
import org.apache.cassandra.sidecar.metrics.RestoreMetrics;
import org.apache.cassandra.sidecar.metrics.SchemaMetrics;
import org.apache.cassandra.sidecar.metrics.ServerMetrics;

public class ServerMetricsImpl
implements ServerMetrics {
    protected final MetricRegistry metricRegistry;
    protected final HealthMetrics healthMetrics;
    protected final ResourceMetrics resourceMetrics;
    protected final RestoreMetrics restoreMetrics;
    protected final SchemaMetrics schemaMetrics;
    protected final CacheMetrics cacheMetrics;
    protected final CoordinationMetrics coordinationMetrics;

    public ServerMetricsImpl(MetricRegistry metricRegistry) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "MetricRegistry can not be null");
        this.healthMetrics = new HealthMetrics(metricRegistry);
        this.resourceMetrics = new ResourceMetrics(metricRegistry);
        this.restoreMetrics = new RestoreMetrics(metricRegistry);
        this.schemaMetrics = new SchemaMetrics(metricRegistry);
        this.cacheMetrics = new CacheMetrics(metricRegistry);
        this.coordinationMetrics = new CoordinationMetrics(metricRegistry);
    }

    @Override
    public HealthMetrics health() {
        return this.healthMetrics;
    }

    @Override
    public ResourceMetrics resource() {
        return this.resourceMetrics;
    }

    @Override
    public RestoreMetrics restore() {
        return this.restoreMetrics;
    }

    @Override
    public SchemaMetrics schema() {
        return this.schemaMetrics;
    }

    @Override
    public CacheMetrics cache() {
        return this.cacheMetrics;
    }

    @Override
    public CoordinationMetrics coordination() {
        return this.coordinationMetrics;
    }
}

