/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics;

import com.codahale.metrics.DefaultSettableGauge;
import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import org.apache.cassandra.sidecar.metrics.NamedMetric;

public class HealthMetrics {
    public static final String DOMAIN = "Sidecar.Server.Health";
    protected final MetricRegistry metricRegistry;
    public final NamedMetric<DefaultSettableGauge<Integer>> cassandraInstancesUp;
    public final NamedMetric<DefaultSettableGauge<Integer>> cassandraInstancesDown;

    public HealthMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry can not be null");
        this.cassandraInstancesUp = NamedMetric.builder(name -> (DefaultSettableGauge)metricRegistry.gauge(name, () -> new DefaultSettableGauge((Object)0))).withDomain(DOMAIN).withName("CassInstancesUp").build();
        this.cassandraInstancesDown = NamedMetric.builder(name -> (DefaultSettableGauge)metricRegistry.gauge(name, () -> new DefaultSettableGauge((Object)0))).withDomain(DOMAIN).withName("CassInstancesDown").build();
    }
}

