/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import com.datastax.driver.core.Session;
import com.google.common.annotations.VisibleForTesting;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.coordination.ClusterLease;
import org.apache.cassandra.sidecar.coordination.ExecuteOnClusterLeaseholderOnly;
import org.apache.cassandra.sidecar.db.schema.AbstractSchema;
import org.apache.cassandra.sidecar.db.schema.SidecarInternalKeyspace;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.cassandra.sidecar.exceptions.SidecarSchemaModificationException;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.SchemaMetrics;
import org.apache.cassandra.sidecar.server.SidecarServerEvents;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.apache.cassandra.sidecar.tasks.PeriodicTaskExecutor;
import org.apache.cassandra.sidecar.tasks.ScheduleDecision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarSchema.class);
    protected static final DurationSpec INITIALIZATION_LOOP_DELAY = MillisecondBoundConfiguration.parse((String)"1s");
    private final Vertx vertx;
    private final PeriodicTaskExecutor periodicTaskExecutor;
    private final SchemaKeyspaceConfiguration schemaKeyspaceConfiguration;
    private final SidecarInternalKeyspace sidecarInternalKeyspace;
    private final CQLSessionProvider cqlSessionProvider;
    private final SchemaMetrics metrics;
    private final ClusterLease clusterLease;
    private boolean isInitialized = false;

    public SidecarSchema(Vertx vertx, PeriodicTaskExecutor periodicTaskExecutor, SidecarConfiguration config, SidecarInternalKeyspace sidecarInternalKeyspace, CQLSessionProvider cqlSessionProvider, SchemaMetrics metrics, ClusterLease clusterLease) {
        this.vertx = vertx;
        this.periodicTaskExecutor = periodicTaskExecutor;
        this.schemaKeyspaceConfiguration = config.serviceConfiguration().schemaKeyspaceConfiguration();
        this.sidecarInternalKeyspace = sidecarInternalKeyspace;
        this.cqlSessionProvider = cqlSessionProvider;
        this.metrics = metrics;
        this.clusterLease = clusterLease;
        if (this.schemaKeyspaceConfiguration.isEnabled()) {
            this.configureSidecarServerEventListeners();
        } else {
            LOGGER.info("Sidecar schema is disabled!");
        }
    }

    private void configureSidecarServerEventListeners() {
        EventBus eventBus = this.vertx.eventBus();
        eventBus.localConsumer(SidecarServerEvents.ON_CASSANDRA_CQL_READY.address(), message -> this.maybeStartSidecarSchemaInitializer());
    }

    @VisibleForTesting
    public void maybeStartSidecarSchemaInitializer() {
        if (!this.schemaKeyspaceConfiguration.isEnabled()) {
            return;
        }
        this.periodicTaskExecutor.schedule(new SidecarSchemaInitializer());
    }

    public boolean isInitialized() {
        return this.schemaKeyspaceConfiguration.isEnabled() && this.isInitialized;
    }

    public void ensureInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Sidecar schema is not initialized!");
        }
    }

    protected void reportSidecarSchemaInitialized() {
        this.vertx.eventBus().publish(SidecarServerEvents.ON_SIDECAR_SCHEMA_INITIALIZED.address(), (Object)"SidecarSchema initialized");
    }

    protected boolean shouldCreateSchema(AbstractSchema schema) {
        if (schema instanceof ExecuteOnClusterLeaseholderOnly) {
            return this.clusterLease.isClaimedByLocalSidecar();
        }
        return true;
    }

    private class SidecarSchemaInitializer
    implements PeriodicTask {
        private SidecarSchemaInitializer() {
        }

        @Override
        public ScheduleDecision scheduleDecision() {
            if (SidecarSchema.this.cqlSessionProvider.getIfConnected() == null) {
                LOGGER.debug("CQL connection is not yet established. Skip this run of initialization.");
                return ScheduleDecision.SKIP;
            }
            return ScheduleDecision.EXECUTE;
        }

        @Override
        public DurationSpec delay() {
            return INITIALIZATION_LOOP_DELAY;
        }

        @Override
        public void execute(Promise<Void> promise) {
            try {
                Session session = SidecarSchema.this.cqlSessionProvider.get();
                SidecarSchema.this.isInitialized = SidecarSchema.this.sidecarInternalKeyspace.initialize(session, SidecarSchema.this::shouldCreateSchema);
                if (SidecarSchema.this.isInitialized) {
                    LOGGER.info("Sidecar schema is initialized. Stopping SchemaSidecarInitializer");
                    SidecarSchema.this.periodicTaskExecutor.unschedule(this);
                    SidecarSchema.this.reportSidecarSchemaInitialized();
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to initialize schema. Retry in {}", (Object)this.delay(), (Object)ex);
                if (ex instanceof CassandraUnavailableException) {
                    return;
                }
                if (ex instanceof SidecarSchemaModificationException) {
                    LOGGER.warn("Failed to modify schema", (Throwable)ex);
                    ((DeltaGauge)SidecarSchema.this.metrics.failedModifications.metric).update(1L);
                }
                ((DeltaGauge)SidecarSchema.this.metrics.failedInitializations.metric).update(1L);
            }
            promise.tryComplete();
        }
    }
}

