/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Session;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.db.schema.AbstractSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.jetbrains.annotations.NotNull;

public class SidecarInternalKeyspace
extends AbstractSchema {
    private final SchemaKeyspaceConfiguration keyspaceConfig;
    private final boolean isEnabled;
    private final Set<TableSchema> tableSchemas = ConcurrentHashMap.newKeySet();

    public SidecarInternalKeyspace(SidecarConfiguration config) {
        this.keyspaceConfig = config.serviceConfiguration().schemaKeyspaceConfiguration();
        this.isEnabled = this.keyspaceConfig.isEnabled();
    }

    public void registerTableSchema(TableSchema schema) {
        if (!this.isEnabled) {
            this.logger.warn("Sidecar schema is disabled!");
            return;
        }
        this.tableSchemas.add(schema);
    }

    protected void prepareStatements(@NotNull Session session) {
    }

    protected boolean exists(@NotNull Metadata metadata) {
        return metadata.getKeyspace(this.keyspaceName()) != null;
    }

    protected boolean initializeInternal(@NotNull Session session, @NotNull Predicate<AbstractSchema> shouldCreateSchema) {
        super.initializeInternal(session, shouldCreateSchema);
        boolean initialized = true;
        for (AbstractSchema abstractSchema : this.tableSchemas) {
            initialized = abstractSchema.initialize(session, shouldCreateSchema) && initialized;
        }
        return initialized;
    }

    protected String keyspaceName() {
        return this.keyspaceConfig.keyspace();
    }

    protected String createSchemaStatement() {
        return String.format("CREATE KEYSPACE IF NOT EXISTS %s WITH REPLICATION = %s", this.keyspaceName(), this.keyspaceConfig.createReplicationStrategyString());
    }
}

