/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Promise;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.SchemaReportingConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.coordination.ExecuteOnClusterLeaseholderOnly;
import org.apache.cassandra.sidecar.datahub.SchemaReporter;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.apache.cassandra.sidecar.tasks.ScheduleDecision;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SchemaReportingTask
implements PeriodicTask,
ExecuteOnClusterLeaseholderOnly {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaReportingTask.class);
    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();
    @NotNull
    protected final SchemaReportingConfiguration configuration;
    @NotNull
    protected final CQLSessionProvider session;
    @NotNull
    protected final SchemaReporter reporter;

    @Inject
    public SchemaReportingTask(@NotNull SidecarConfiguration configuration, @NotNull CQLSessionProvider session, @NotNull SchemaReporter reporter) {
        this.configuration = configuration.schemaReportingConfiguration();
        this.session = session;
        this.reporter = reporter;
    }

    @Override
    public ScheduleDecision scheduleDecision() {
        return this.configuration.enabled() ? ScheduleDecision.EXECUTE : ScheduleDecision.SKIP;
    }

    @Override
    public DurationSpec initialDelay() {
        MillisecondBoundConfiguration maximum = this.configuration.initialDelay();
        return new MillisecondBoundConfiguration(RANDOM.nextLong(maximum.quantity()), maximum.unit());
    }

    @Override
    public DurationSpec delay() {
        return this.configuration.executeInterval();
    }

    @Override
    public void execute(Promise<Void> promise) {
        try {
            this.reporter.process(this.session.get().getCluster());
            promise.complete();
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to convert and report the current schema", throwable);
            promise.fail(throwable);
        }
    }
}

