/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TableMetadata;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.linkedin.data.template.RecordTemplate;
import datahub.client.Emitter;
import datahub.event.MetadataChangeProposalWrapper;
import java.util.List;
import java.util.stream.Stream;
import org.apache.cassandra.sidecar.common.server.utils.ThrowableUtils;
import org.apache.cassandra.sidecar.datahub.ClusterToAspectConverter;
import org.apache.cassandra.sidecar.datahub.ClusterToDataPlatformInfoConverter;
import org.apache.cassandra.sidecar.datahub.ClusterToDataPlatformInstancePropertiesConverter;
import org.apache.cassandra.sidecar.datahub.EmitterFactory;
import org.apache.cassandra.sidecar.datahub.IdentifiersProvider;
import org.apache.cassandra.sidecar.datahub.KeyspaceToAspectConverter;
import org.apache.cassandra.sidecar.datahub.KeyspaceToBrowsePathsV2Converter;
import org.apache.cassandra.sidecar.datahub.KeyspaceToContainerPropertiesConverter;
import org.apache.cassandra.sidecar.datahub.KeyspaceToDataPlatformInstanceConverter;
import org.apache.cassandra.sidecar.datahub.KeyspaceToSubTypesConverter;
import org.apache.cassandra.sidecar.datahub.TableToAspectConverter;
import org.apache.cassandra.sidecar.datahub.TableToBrowsePathsConverter;
import org.apache.cassandra.sidecar.datahub.TableToBrowsePathsV2Converter;
import org.apache.cassandra.sidecar.datahub.TableToContainerConverter;
import org.apache.cassandra.sidecar.datahub.TableToDataPlatformInstanceConverter;
import org.apache.cassandra.sidecar.datahub.TableToDatasetPropertiesConverter;
import org.apache.cassandra.sidecar.datahub.TableToSchemaMetadataConverter;
import org.apache.cassandra.sidecar.datahub.TableToSubTypesConverter;
import org.jetbrains.annotations.NotNull;

@Singleton
public class SchemaReporter {
    @NotNull
    protected final IdentifiersProvider identifiersProvider;
    @NotNull
    protected final List<ClusterToAspectConverter<? extends RecordTemplate>> clusterConverters;
    @NotNull
    protected final List<KeyspaceToAspectConverter<? extends RecordTemplate>> keyspaceConverters;
    @NotNull
    protected final List<TableToAspectConverter<? extends RecordTemplate>> tableConverters;
    @NotNull
    protected final EmitterFactory emitterFactory;

    @Inject
    public SchemaReporter(@NotNull IdentifiersProvider identifiersProvider, @NotNull EmitterFactory emitterFactory) {
        this(identifiersProvider, (List<ClusterToAspectConverter<? extends RecordTemplate>>)ImmutableList.of((Object)new ClusterToDataPlatformInfoConverter(identifiersProvider), (Object)new ClusterToDataPlatformInstancePropertiesConverter(identifiersProvider)), (List<KeyspaceToAspectConverter<? extends RecordTemplate>>)ImmutableList.of((Object)new KeyspaceToContainerPropertiesConverter(identifiersProvider), (Object)new KeyspaceToSubTypesConverter(identifiersProvider), (Object)new KeyspaceToDataPlatformInstanceConverter(identifiersProvider), (Object)new KeyspaceToBrowsePathsV2Converter(identifiersProvider)), (List<TableToAspectConverter<? extends RecordTemplate>>)ImmutableList.of((Object)new TableToDatasetPropertiesConverter(identifiersProvider), (Object)new TableToSchemaMetadataConverter(identifiersProvider), (Object)new TableToContainerConverter(identifiersProvider), (Object)new TableToSubTypesConverter(identifiersProvider), (Object)new TableToDataPlatformInstanceConverter(identifiersProvider), (Object)new TableToBrowsePathsV2Converter(identifiersProvider), (Object)new TableToBrowsePathsConverter(identifiersProvider)), emitterFactory);
    }

    protected SchemaReporter(@NotNull IdentifiersProvider identifiersProvider, @NotNull List<ClusterToAspectConverter<? extends RecordTemplate>> clusterConverters, @NotNull List<KeyspaceToAspectConverter<? extends RecordTemplate>> keyspaceConverters, @NotNull List<TableToAspectConverter<? extends RecordTemplate>> tableConverters, @NotNull EmitterFactory emitterFactory) {
        this.identifiersProvider = identifiersProvider;
        this.clusterConverters = clusterConverters;
        this.keyspaceConverters = keyspaceConverters;
        this.tableConverters = tableConverters;
        this.emitterFactory = emitterFactory;
    }

    public void process(@NotNull Cluster cluster) {
        try (Emitter emitter = this.emitterFactory.emitter();){
            this.stream(cluster.getMetadata()).forEach(ThrowableUtils.consumer(arg_0 -> ((Emitter)emitter).emit(arg_0)));
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot extract schema for cluster " + this.identifiersProvider.cluster(), exception);
        }
    }

    @NotNull
    protected Stream<MetadataChangeProposalWrapper<? extends RecordTemplate>> stream(@NotNull Metadata metadata) {
        return Streams.concat((Stream[])new Stream[]{this.clusterConverters.stream().map(ThrowableUtils.function(converter -> converter.convert(metadata))), metadata.getKeyspaces().stream().filter(this::neitherVirtualNorSystem).flatMap(this::stream)});
    }

    @NotNull
    protected Stream<MetadataChangeProposalWrapper<? extends RecordTemplate>> stream(@NotNull KeyspaceMetadata keyspace) {
        return Streams.concat((Stream[])new Stream[]{this.keyspaceConverters.stream().map(ThrowableUtils.function(converter -> converter.convert(keyspace))), keyspace.getTables().stream().flatMap(this::stream)});
    }

    @NotNull
    protected Stream<MetadataChangeProposalWrapper<? extends RecordTemplate>> stream(@NotNull TableMetadata table) {
        return this.tableConverters.stream().map(ThrowableUtils.function(converter -> converter.convert(table)));
    }

    protected boolean neitherVirtualNorSystem(@NotNull KeyspaceMetadata keyspace) {
        if (keyspace.isVirtual()) {
            return false;
        }
        String name = keyspace.getName();
        return !name.equals("system") && !name.startsWith("system_") && !name.equals("sidecar_internal");
    }
}

