/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpMethod;
import org.apache.cassandra.sidecar.config.SchemaReportingConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.datahub.JsonEmitter;
import org.jetbrains.annotations.NotNull;

public class HttpEmitter
extends JsonEmitter {
    @NotNull
    protected final HttpClient client;
    @NotNull
    protected final String endpoint;
    @NotNull
    protected final HttpMethod method;

    public HttpEmitter(@NotNull Vertx vertx, @NotNull SidecarConfiguration sidecarConfiguration) {
        SchemaReportingConfiguration reportingConfiguration = sidecarConfiguration.schemaReportingConfiguration();
        this.client = vertx.createHttpClient();
        this.endpoint = reportingConfiguration.endpoint();
        this.method = reportingConfiguration.method();
    }

    @Override
    public synchronized void close() {
        super.close();
        String content = this.content();
        this.client.request(this.method, this.endpoint).onSuccess(request -> {
            request.putHeader("Content-Type", "Application/JSON");
            request.putHeader("Content-Length", Integer.toString(content.length()));
            request.write(content);
            request.end();
        });
    }
}

