/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.common.server.utils.MinuteBoundConfiguration;
import org.apache.cassandra.sidecar.config.CdcConfiguration;
import org.apache.cassandra.sidecar.config.CoordinationConfiguration;
import org.apache.cassandra.sidecar.config.JmxConfiguration;
import org.apache.cassandra.sidecar.config.SSTableImportConfiguration;
import org.apache.cassandra.sidecar.config.SSTableSnapshotConfiguration;
import org.apache.cassandra.sidecar.config.SSTableUploadConfiguration;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.config.ThrottleConfiguration;
import org.apache.cassandra.sidecar.config.TrafficShapingConfiguration;
import org.apache.cassandra.sidecar.config.WorkerPoolConfiguration;
import org.apache.cassandra.sidecar.config.yaml.CdcConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.CoordinationConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.JmxConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.SSTableImportConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.SSTableSnapshotConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.SSTableUploadConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.SchemaKeyspaceConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.ThrottleConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.TrafficShapingConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.WorkerPoolConfigurationImpl;
import org.apache.cassandra.sidecar.exceptions.ConfigurationException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceConfigurationImpl
implements ServiceConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceConfigurationImpl.class);
    public static final String HOST_PROPERTY = "host";
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final String PORT_PROPERTY = "port";
    public static final int DEFAULT_PORT = 9043;
    public static final String REQUEST_IDLE_TIMEOUT_PROPERTY = "request_idle_timeout";
    public static final MillisecondBoundConfiguration DEFAULT_REQUEST_IDLE_TIMEOUT = MillisecondBoundConfiguration.parse((String)"5m");
    public static final String REQUEST_TIMEOUT_PROPERTY = "request_timeout";
    public static final MillisecondBoundConfiguration DEFAULT_REQUEST_TIMEOUT = MillisecondBoundConfiguration.parse((String)"5m");
    public static final String TCP_KEEP_ALIVE_PROPERTY = "tcp_keep_alive";
    public static final boolean DEFAULT_TCP_KEEP_ALIVE = false;
    public static final String ACCEPT_BACKLOG_PROPERTY = "accept_backlog";
    public static final int DEFAULT_ACCEPT_BACKLOG = 1024;
    public static final String ALLOWABLE_TIME_SKEW_PROPERTY = "allowable_time_skew";
    public static final MinuteBoundConfiguration DEFAULT_ALLOWABLE_TIME_SKEW = MinuteBoundConfiguration.parse((String)"1h");
    private static final String SERVER_VERTICLE_INSTANCES_PROPERTY = "server_verticle_instances";
    private static final String OPERATIONAL_JOB_TRACKER_SIZE_PROPERTY = "operations_job_tracker_size";
    private static final String OPERATIONAL_JOB_EXECUTION_MAX_WAIT_TIME_PROPERTY = "operations_job_sync_response_timeout";
    private static final int DEFAULT_SERVER_VERTICLE_INSTANCES = 1;
    private static final int DEFAULT_OPERATIONAL_JOB_TRACKER_SIZE = 64;
    private static final MillisecondBoundConfiguration DEFAULT_OPERATIONAL_JOB_EXECUTION_MAX_WAIT_TIME = MillisecondBoundConfiguration.parse((String)"5s");
    public static final String THROTTLE_PROPERTY = "throttle";
    public static final String SSTABLE_UPLOAD_PROPERTY = "sstable_upload";
    public static final String SSTABLE_IMPORT_PROPERTY = "sstable_import";
    public static final String SSTABLE_SNAPSHOT_PROPERTY = "sstable_snapshot";
    public static final String WORKER_POOLS_PROPERTY = "worker_pools";
    private static final String JMX_PROPERTY = "jmx";
    private static final String TRAFFIC_SHAPING_PROPERTY = "traffic_shaping";
    private static final String SCHEMA = "schema";
    private static final String CDC = "cdc";
    private static final String COORDINATION = "coordination";
    protected static final Map<String, WorkerPoolConfiguration> DEFAULT_WORKER_POOLS_CONFIGURATION = Collections.unmodifiableMap(new HashMap<String, WorkerPoolConfiguration>(){
        {
            this.put("service", new WorkerPoolConfigurationImpl("sidecar-worker-pool", 20, MillisecondBoundConfiguration.parse((String)"60s")));
            this.put("internal", new WorkerPoolConfigurationImpl("sidecar-internal-worker-pool", 20, MillisecondBoundConfiguration.parse((String)"15m")));
        }
    });
    @JsonProperty(value="host", defaultValue="0.0.0.0")
    protected final String host;
    @JsonProperty(value="port", defaultValue="9043")
    protected final int port;
    protected MillisecondBoundConfiguration requestIdleTimeout;
    protected MillisecondBoundConfiguration requestTimeout;
    @JsonProperty(value="tcp_keep_alive", defaultValue="false")
    protected final boolean tcpKeepAlive;
    @JsonProperty(value="accept_backlog", defaultValue="1024")
    protected final int acceptBacklog;
    protected MinuteBoundConfiguration allowableTimeSkew;
    @JsonProperty(value="server_verticle_instances", defaultValue="1")
    protected final int serverVerticleInstances;
    @JsonProperty(value="operations_job_tracker_size", defaultValue="64")
    protected final int operationalJobTrackerSize;
    @JsonProperty(value="operations_job_sync_response_timeout")
    protected final MillisecondBoundConfiguration operationalJobExecutionMaxWaitTime;
    @JsonProperty(value="throttle")
    protected final ThrottleConfiguration throttleConfiguration;
    @JsonProperty(value="sstable_upload")
    protected final SSTableUploadConfiguration sstableUploadConfiguration;
    @JsonProperty(value="sstable_import")
    protected final SSTableImportConfiguration sstableImportConfiguration;
    @JsonProperty(value="sstable_snapshot")
    protected final SSTableSnapshotConfiguration sstableSnapshotConfiguration;
    @JsonProperty(value="worker_pools")
    protected final Map<String, ? extends WorkerPoolConfiguration> workerPoolsConfiguration;
    @JsonProperty(value="jmx")
    protected final JmxConfiguration jmxConfiguration;
    @JsonProperty(value="traffic_shaping")
    protected final TrafficShapingConfiguration trafficShapingConfiguration;
    @JsonProperty(value="schema")
    protected final SchemaKeyspaceConfiguration schemaKeyspaceConfiguration;
    @JsonProperty(value="cdc")
    protected final CdcConfiguration cdcConfiguration;
    @JsonProperty(value="coordination")
    protected final CoordinationConfiguration coordinationConfiguration;

    public ServiceConfigurationImpl() {
        this(ServiceConfigurationImpl.builder());
    }

    protected ServiceConfigurationImpl(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.requestIdleTimeout = builder.requestIdleTimeout;
        this.requestTimeout = builder.requestTimeout;
        this.tcpKeepAlive = builder.tcpKeepAlive;
        this.acceptBacklog = builder.acceptBacklog;
        this.allowableTimeSkew = builder.allowableTimeSkew;
        this.serverVerticleInstances = builder.serverVerticleInstances;
        this.operationalJobTrackerSize = builder.operationalJobTrackerSize;
        this.operationalJobExecutionMaxWaitTime = builder.operationalJobExecutionMaxWaitTime;
        this.throttleConfiguration = builder.throttleConfiguration;
        this.sstableUploadConfiguration = builder.sstableUploadConfiguration;
        this.sstableImportConfiguration = builder.sstableImportConfiguration;
        this.sstableSnapshotConfiguration = builder.sstableSnapshotConfiguration;
        this.workerPoolsConfiguration = builder.workerPoolsConfiguration;
        this.jmxConfiguration = builder.jmxConfiguration;
        this.trafficShapingConfiguration = builder.trafficShapingConfiguration;
        this.schemaKeyspaceConfiguration = builder.schemaKeyspaceConfiguration;
        this.cdcConfiguration = builder.cdcConfiguration;
        this.coordinationConfiguration = builder.coordinationConfiguration;
    }

    @Override
    @JsonProperty(value="host")
    public String host() {
        return this.host;
    }

    @Override
    @JsonProperty(value="port")
    public int port() {
        return this.port;
    }

    @Override
    @JsonProperty(value="request_idle_timeout")
    public MillisecondBoundConfiguration requestIdleTimeout() {
        return this.requestIdleTimeout;
    }

    @JsonProperty(value="request_idle_timeout")
    public void setRequestIdleTimeout(MillisecondBoundConfiguration requestIdleTimeout) {
        this.requestIdleTimeout = requestIdleTimeout;
    }

    @JsonProperty(value="request_idle_timeout_millis")
    @Deprecated
    public void setRequestIdleTimeoutMillis(long requestIdleTimeoutMillis) {
        LOGGER.warn("'request_idle_timeout_millis' is deprecated, use '{}' instead", (Object)REQUEST_IDLE_TIMEOUT_PROPERTY);
        this.setRequestIdleTimeout(new MillisecondBoundConfiguration(requestIdleTimeoutMillis, TimeUnit.MILLISECONDS));
    }

    @Override
    @JsonProperty(value="request_timeout")
    public MillisecondBoundConfiguration requestTimeout() {
        return this.requestTimeout;
    }

    @JsonProperty(value="request_timeout")
    public void setRequestTimeout(MillisecondBoundConfiguration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @JsonProperty(value="request_timeout_millis")
    @Deprecated
    public void setRequestTimeoutMillis(long requestTimeoutMillis) {
        LOGGER.warn("'request_timeout_millis' is deprecated, use '{}' instead", (Object)REQUEST_TIMEOUT_PROPERTY);
        this.setRequestTimeout(new MillisecondBoundConfiguration(requestTimeoutMillis, TimeUnit.MILLISECONDS));
    }

    @Override
    @JsonProperty(value="tcp_keep_alive")
    public boolean tcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    @Override
    @JsonProperty(value="accept_backlog")
    public int acceptBacklog() {
        return this.acceptBacklog;
    }

    @Override
    @JsonProperty(value="allowable_time_skew")
    public MinuteBoundConfiguration allowableTimeSkew() {
        return this.allowableTimeSkew;
    }

    @JsonProperty(value="allowable_time_skew")
    public void setAllowableTimeSkew(MinuteBoundConfiguration allowableTimeSkew) {
        if (allowableTimeSkew.compareTo((DurationSpec)MinuteBoundConfiguration.parse((String)"1m")) < 0) {
            throw new ConfigurationException(String.format("Invalid %s value (%s). The minimum allowed value is 1 minute (1m)", ALLOWABLE_TIME_SKEW_PROPERTY, allowableTimeSkew));
        }
        this.allowableTimeSkew = allowableTimeSkew;
    }

    @JsonProperty(value="allowable_time_skew_in_minutes")
    @Deprecated
    public void setAllowableTimeSkewInMinutes(long allowableTimeSkewInMinutes) {
        LOGGER.warn("'allowable_time_skew_in_minutes' is deprecated, use '{}' instead", (Object)ALLOWABLE_TIME_SKEW_PROPERTY);
        this.setAllowableTimeSkew(new MinuteBoundConfiguration(allowableTimeSkewInMinutes, TimeUnit.MINUTES));
    }

    @Override
    @JsonProperty(value="server_verticle_instances")
    public int serverVerticleInstances() {
        return this.serverVerticleInstances;
    }

    @Override
    @JsonProperty(value="operations_job_tracker_size")
    public int operationalJobTrackerSize() {
        return this.operationalJobTrackerSize;
    }

    @Override
    @JsonProperty(value="operations_job_sync_response_timeout")
    public MillisecondBoundConfiguration operationalJobExecutionMaxWaitTime() {
        return this.operationalJobExecutionMaxWaitTime;
    }

    @Override
    @JsonProperty(value="throttle")
    public ThrottleConfiguration throttleConfiguration() {
        return this.throttleConfiguration;
    }

    @Override
    @JsonProperty(value="sstable_upload")
    public SSTableUploadConfiguration sstableUploadConfiguration() {
        return this.sstableUploadConfiguration;
    }

    @Override
    @JsonProperty(value="sstable_import")
    public SSTableImportConfiguration sstableImportConfiguration() {
        return this.sstableImportConfiguration;
    }

    @Override
    @JsonProperty(value="sstable_snapshot")
    public SSTableSnapshotConfiguration sstableSnapshotConfiguration() {
        return this.sstableSnapshotConfiguration;
    }

    @Override
    @JsonProperty(value="worker_pools")
    public Map<String, ? extends WorkerPoolConfiguration> workerPoolsConfiguration() {
        return this.workerPoolsConfiguration;
    }

    @Override
    @JsonProperty(value="jmx")
    public JmxConfiguration jmxConfiguration() {
        return this.jmxConfiguration;
    }

    @Override
    @JsonProperty(value="traffic_shaping")
    public TrafficShapingConfiguration trafficShapingConfiguration() {
        return this.trafficShapingConfiguration;
    }

    @Override
    @JsonProperty(value="schema")
    public SchemaKeyspaceConfiguration schemaKeyspaceConfiguration() {
        return this.schemaKeyspaceConfiguration;
    }

    @Override
    @JsonProperty(value="cdc")
    @Nullable
    public CdcConfiguration cdcConfiguration() {
        return this.cdcConfiguration;
    }

    @Override
    @JsonProperty(value="coordination")
    public CoordinationConfiguration coordinationConfiguration() {
        return this.coordinationConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements DataObjectBuilder<Builder, ServiceConfigurationImpl> {
        protected String host = "0.0.0.0";
        protected int port = 9043;
        protected MillisecondBoundConfiguration requestIdleTimeout = DEFAULT_REQUEST_IDLE_TIMEOUT;
        protected MillisecondBoundConfiguration requestTimeout = DEFAULT_REQUEST_TIMEOUT;
        protected boolean tcpKeepAlive = false;
        protected int acceptBacklog = 1024;
        protected MinuteBoundConfiguration allowableTimeSkew = DEFAULT_ALLOWABLE_TIME_SKEW;
        protected int serverVerticleInstances = 1;
        protected int operationalJobTrackerSize = 64;
        protected MillisecondBoundConfiguration operationalJobExecutionMaxWaitTime = DEFAULT_OPERATIONAL_JOB_EXECUTION_MAX_WAIT_TIME;
        protected ThrottleConfiguration throttleConfiguration = new ThrottleConfigurationImpl();
        protected SSTableUploadConfiguration sstableUploadConfiguration = new SSTableUploadConfigurationImpl();
        protected SSTableImportConfiguration sstableImportConfiguration = new SSTableImportConfigurationImpl();
        protected SSTableSnapshotConfiguration sstableSnapshotConfiguration = new SSTableSnapshotConfigurationImpl();
        protected Map<String, ? extends WorkerPoolConfiguration> workerPoolsConfiguration = DEFAULT_WORKER_POOLS_CONFIGURATION;
        protected JmxConfiguration jmxConfiguration = new JmxConfigurationImpl();
        protected TrafficShapingConfiguration trafficShapingConfiguration = new TrafficShapingConfigurationImpl();
        protected SchemaKeyspaceConfiguration schemaKeyspaceConfiguration = new SchemaKeyspaceConfigurationImpl();
        protected CdcConfiguration cdcConfiguration = new CdcConfigurationImpl();
        protected CoordinationConfiguration coordinationConfiguration = new CoordinationConfigurationImpl();

        private Builder() {
        }

        public Builder self() {
            return this;
        }

        public Builder host(String host) {
            return (Builder)this.update(b -> {
                b.host = host;
            });
        }

        public Builder port(int port) {
            return (Builder)this.update(b -> {
                b.port = port;
            });
        }

        public Builder requestIdleTimeout(MillisecondBoundConfiguration requestIdleTimeout) {
            return (Builder)this.update(b -> {
                b.requestIdleTimeout = requestIdleTimeout;
            });
        }

        public Builder requestTimeout(MillisecondBoundConfiguration requestTimeout) {
            return (Builder)this.update(b -> {
                b.requestTimeout = requestTimeout;
            });
        }

        public Builder tcpKeepAlive(boolean tcpKeepAlive) {
            return (Builder)this.update(b -> {
                b.tcpKeepAlive = tcpKeepAlive;
            });
        }

        public Builder acceptBacklog(int acceptBacklog) {
            return (Builder)this.update(b -> {
                b.acceptBacklog = acceptBacklog;
            });
        }

        public Builder allowableTimeSkew(MinuteBoundConfiguration allowableTimeSkew) {
            return (Builder)this.update(b -> {
                b.allowableTimeSkew = allowableTimeSkew;
            });
        }

        public Builder serverVerticleInstances(int serverVerticleInstances) {
            return (Builder)this.update(b -> {
                b.serverVerticleInstances = serverVerticleInstances;
            });
        }

        public Builder operationalJobTrackerSize(int operationalJobTrackerSize) {
            return (Builder)this.update(b -> {
                b.operationalJobTrackerSize = operationalJobTrackerSize;
            });
        }

        public Builder operationalJobExecutionMaxWaitTime(MillisecondBoundConfiguration operationalJobExecutionMaxWaitTime) {
            return (Builder)this.update(b -> {
                b.operationalJobExecutionMaxWaitTime = operationalJobExecutionMaxWaitTime;
            });
        }

        public Builder throttleConfiguration(ThrottleConfiguration throttleConfiguration) {
            return (Builder)this.update(b -> {
                b.throttleConfiguration = throttleConfiguration;
            });
        }

        public Builder sstableUploadConfiguration(SSTableUploadConfiguration sstableUploadConfiguration) {
            return (Builder)this.update(b -> {
                b.sstableUploadConfiguration = sstableUploadConfiguration;
            });
        }

        public Builder sstableImportConfiguration(SSTableImportConfiguration sstableImportConfiguration) {
            return (Builder)this.update(b -> {
                b.sstableImportConfiguration = sstableImportConfiguration;
            });
        }

        public Builder sstableSnapshotConfiguration(SSTableSnapshotConfiguration sstableSnapshotConfiguration) {
            return (Builder)this.update(b -> {
                b.sstableSnapshotConfiguration = sstableSnapshotConfiguration;
            });
        }

        public Builder workerPoolsConfiguration(Map<String, ? extends WorkerPoolConfiguration> workerPoolsConfiguration) {
            return (Builder)this.update(b -> {
                b.workerPoolsConfiguration = workerPoolsConfiguration;
            });
        }

        public Builder jmxConfiguration(JmxConfiguration jmxConfiguration) {
            return (Builder)this.update(b -> {
                b.jmxConfiguration = jmxConfiguration;
            });
        }

        public Builder trafficShapingConfiguration(TrafficShapingConfiguration trafficShapingConfiguration) {
            return (Builder)this.update(b -> {
                b.trafficShapingConfiguration = trafficShapingConfiguration;
            });
        }

        public Builder schemaKeyspaceConfiguration(SchemaKeyspaceConfiguration schemaKeyspaceConfiguration) {
            return (Builder)this.update(b -> {
                b.schemaKeyspaceConfiguration = schemaKeyspaceConfiguration;
            });
        }

        public Builder cdcConfiguration(CdcConfiguration configuration) {
            return (Builder)this.update(b -> {
                b.cdcConfiguration = configuration;
            });
        }

        public Builder coordinationConfiguration(CoordinationConfiguration coordinationConfiguration) {
            return (Builder)this.update(b -> {
                b.coordinationConfiguration = coordinationConfiguration;
            });
        }

        public ServiceConfigurationImpl build() {
            return new ServiceConfigurationImpl(this);
        }
    }
}

