/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.common.server.utils.MinuteBoundConfiguration;
import org.apache.cassandra.sidecar.config.CdcConfiguration;
import org.apache.cassandra.sidecar.config.CoordinationConfiguration;
import org.apache.cassandra.sidecar.config.JmxConfiguration;
import org.apache.cassandra.sidecar.config.SSTableImportConfiguration;
import org.apache.cassandra.sidecar.config.SSTableSnapshotConfiguration;
import org.apache.cassandra.sidecar.config.SSTableUploadConfiguration;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.config.ThrottleConfiguration;
import org.apache.cassandra.sidecar.config.TrafficShapingConfiguration;
import org.apache.cassandra.sidecar.config.WorkerPoolConfiguration;

public interface ServiceConfiguration {
    public static final String SERVICE_POOL = "service";
    public static final String INTERNAL_POOL = "internal";
    public static final String HOST_ID = UUID.randomUUID().toString();

    default public String hostId() {
        return HOST_ID;
    }

    public String host();

    default public List<SocketAddress> listenSocketAddresses() {
        return Collections.singletonList(new SocketAddressImpl(this.port(), Objects.requireNonNull(this.host(), "host must be provided")));
    }

    public int port();

    public MillisecondBoundConfiguration requestIdleTimeout();

    public MillisecondBoundConfiguration requestTimeout();

    public boolean tcpKeepAlive();

    public int acceptBacklog();

    public MinuteBoundConfiguration allowableTimeSkew();

    public int serverVerticleInstances();

    public int operationalJobTrackerSize();

    public MillisecondBoundConfiguration operationalJobExecutionMaxWaitTime();

    public ThrottleConfiguration throttleConfiguration();

    public SSTableUploadConfiguration sstableUploadConfiguration();

    public SSTableImportConfiguration sstableImportConfiguration();

    public SSTableSnapshotConfiguration sstableSnapshotConfiguration();

    public Map<String, ? extends WorkerPoolConfiguration> workerPoolsConfiguration();

    default public WorkerPoolConfiguration serverWorkerPoolConfiguration() {
        return this.workerPoolsConfiguration().get(SERVICE_POOL);
    }

    default public WorkerPoolConfiguration serverInternalWorkerPoolConfiguration() {
        return this.workerPoolsConfiguration().get(INTERNAL_POOL);
    }

    public JmxConfiguration jmxConfiguration();

    public TrafficShapingConfiguration trafficShapingConfiguration();

    public SchemaKeyspaceConfiguration schemaKeyspaceConfiguration();

    public CdcConfiguration cdcConfiguration();

    public CoordinationConfiguration coordinationConfiguration();
}

