/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.cluster;

import com.codahale.metrics.DefaultSettableGauge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import org.apache.cassandra.sidecar.common.response.NodeSettings;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.ClusterMembershipOperations;
import org.apache.cassandra.sidecar.common.server.ICassandraAdapter;
import org.apache.cassandra.sidecar.common.server.JmxClient;
import org.apache.cassandra.sidecar.common.server.MetricsOperations;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.TableOperations;
import org.apache.cassandra.sidecar.common.server.utils.DriverUtils;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.cassandra.sidecar.metrics.instance.InstanceHealthMetrics;
import org.apache.cassandra.sidecar.server.SidecarServerEvents;
import org.apache.cassandra.sidecar.utils.CassandraVersionProvider;
import org.apache.cassandra.sidecar.utils.SimpleCassandraVersion;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraAdapterDelegate
implements ICassandraAdapter,
Host.StateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraAdapterDelegate.class);
    private final Vertx vertx;
    private final int cassandraInstanceId;
    private final DriverUtils driverUtils;
    private final String sidecarVersion;
    private final CassandraVersionProvider versionProvider;
    private final CQLSessionProvider cqlSessionProvider;
    private final JmxClient jmxClient;
    private final JmxNotificationListener notificationListener;
    private SimpleCassandraVersion currentVersion;
    private volatile ICassandraAdapter adapter;
    private final AtomicBoolean isNativeUp = new AtomicBoolean(false);
    private volatile NodeSettings nodeSettingsFromJmx = null;
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final AtomicBoolean isHealthCheckActive = new AtomicBoolean(false);
    private final InetSocketAddress localNativeTransportAddress;
    private final InstanceHealthMetrics healthMetrics;
    private volatile Host host;
    private volatile boolean closed = false;

    public CassandraAdapterDelegate(Vertx vertx, int cassandraInstanceId, CassandraVersionProvider versionProvider, CQLSessionProvider session, JmxClient jmxClient, DriverUtils driverUtils, String sidecarVersion, String host, int port, InstanceHealthMetrics healthMetrics) {
        this.vertx = Objects.requireNonNull(vertx);
        this.cassandraInstanceId = cassandraInstanceId;
        this.driverUtils = driverUtils;
        this.localNativeTransportAddress = new InetSocketAddress(host, port);
        this.sidecarVersion = sidecarVersion;
        this.versionProvider = versionProvider;
        this.cqlSessionProvider = session;
        this.jmxClient = jmxClient;
        this.healthMetrics = healthMetrics;
        this.notificationListener = this.initializeJmxListener();
    }

    protected JmxNotificationListener initializeJmxListener() {
        JmxNotificationListener notificationListener = new JmxNotificationListener();
        this.jmxClient.registerListener((NotificationListener)notificationListener);
        return notificationListener;
    }

    private void maybeRegisterHostListener(@NotNull Session session) {
        Cluster cluster;
        if (!this.registered.get() && !(cluster = session.getCluster()).isClosed() && this.registered.compareAndSet(false, true)) {
            cluster.register((Host.StateListener)this);
        }
    }

    private void maybeUnregisterHostListener(@NotNull Session session) {
        Cluster cluster;
        if (this.registered.get() && !(cluster = session.getCluster()).isClosed() && this.registered.compareAndSet(true, false)) {
            cluster.unregister((Host.StateListener)this);
        }
    }

    public void healthCheck() {
        if (this.closed) {
            LOGGER.debug("Skipping health check for cassandraInstanceId={}. Delegate is closed", (Object)this.cassandraInstanceId);
            return;
        }
        if (this.isHealthCheckActive.compareAndSet(false, true)) {
            try {
                this.jmxHealthCheck();
                this.nativeProtocolHealthCheck();
            }
            finally {
                this.isHealthCheckActive.set(false);
            }
        } else {
            LOGGER.debug("Skipping health check for cassandraInstanceId={} because there's an active check at the moment", (Object)this.cassandraInstanceId);
        }
    }

    protected synchronized void jmxHealthCheck() {
        try {
            NodeSettings newNodeSettings = this.newNodeSettingsFromJmx();
            if (!newNodeSettings.equals((Object)this.nodeSettingsFromJmx)) {
                SimpleCassandraVersion previousVersion = this.currentVersion;
                this.currentVersion = SimpleCassandraVersion.create(newNodeSettings.releaseVersion());
                this.adapter = this.versionProvider.cassandra(newNodeSettings.releaseVersion()).create(this.cqlSessionProvider, this.jmxClient, this.localNativeTransportAddress);
                this.nodeSettingsFromJmx = newNodeSettings;
                LOGGER.info("Cassandra version change detected (from={} to={}) for cassandraInstanceId={}. New adapter loaded={}", new Object[]{previousVersion, this.currentVersion, this.cassandraInstanceId, this.adapter});
                this.notifyJmxConnection();
            }
            LOGGER.trace("Cassandra version {}", (Object)newNodeSettings.releaseVersion());
        }
        catch (RuntimeException e) {
            LOGGER.debug("Unable to connect JMX to Cassandra instance {}", (Object)this.cassandraInstanceId, (Object)e);
            this.markJmxDownAndMaybeNotifyDisconnection();
        }
    }

    protected void nativeProtocolHealthCheck() {
        Session activeSession;
        try {
            activeSession = this.cqlSessionProvider.get();
        }
        catch (CassandraUnavailableException cue) {
            LOGGER.info("No local CQL session is available for cassandraInstanceId={}. Cassandra instance is down presumably.", (Object)this.cassandraInstanceId);
            this.markNativeDownAndMaybeNotifyDisconnection();
            return;
        }
        this.maybeRegisterHostListener(activeSession);
        try {
            SimpleStatement healthCheckStatement = new SimpleStatement("SELECT release_version FROM system.local");
            Metadata metadata = activeSession.getCluster().getMetadata();
            this.host = this.getHost(metadata);
            if (this.host == null) {
                LOGGER.warn("Could not find host in cluster metadata by address and port {}", (Object)this.localNativeTransportAddress);
                return;
            }
            healthCheckStatement.setHost(this.host);
            healthCheckStatement.setConsistencyLevel(ConsistencyLevel.ONE);
            Row row = activeSession.execute((Statement)healthCheckStatement).one();
            Preconditions.checkArgument((row != null ? 1 : 0) != 0, (String)"Session execution result should never be null");
            if (this.isNativeUp.compareAndSet(false, true)) {
                this.notifyNativeConnection();
            }
        }
        catch (NoHostAvailableException | IllegalArgumentException e) {
            LOGGER.debug("Unexpected error querying Cassandra instance {}", (Object)this.cassandraInstanceId, (Object)e);
            this.markNativeDownAndMaybeNotifyDisconnection();
            this.maybeUnregisterHostListener(activeSession);
        }
    }

    protected NodeSettings newNodeSettingsFromJmx() {
        LimitedStorageOperations storageOperations = (LimitedStorageOperations)this.jmxClient.proxy(LimitedStorageOperations.class, "org.apache.cassandra.db:type=StorageService");
        LimitedEndpointSnitchOperations endpointSnitchOperations = (LimitedEndpointSnitchOperations)this.jmxClient.proxy(LimitedEndpointSnitchOperations.class, "org.apache.cassandra.db:type=EndpointSnitchInfo");
        String releaseVersion = storageOperations.getReleaseVersion();
        String partitionerName = storageOperations.getPartitionerName();
        List<String> tokens = this.maybeGetTokens(storageOperations);
        String dataCenter = endpointSnitchOperations.getDatacenter();
        return NodeSettings.builder().releaseVersion(releaseVersion).partitioner(partitionerName).sidecarVersion(this.sidecarVersion).datacenter(dataCenter).tokens(new LinkedHashSet<String>(tokens)).rpcAddress(this.localNativeTransportAddress.getAddress()).rpcPort(this.localNativeTransportAddress.getPort()).build();
    }

    protected List<String> maybeGetTokens(LimitedStorageOperations storageOperations) {
        try {
            return storageOperations.getTokens();
        }
        catch (AssertionError aex) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Host getHost(Metadata metadata) {
        if (this.host == null) {
            CassandraAdapterDelegate cassandraAdapterDelegate = this;
            synchronized (cassandraAdapterDelegate) {
                if (this.host == null) {
                    this.host = this.driverUtils.getHost(metadata, this.localNativeTransportAddress);
                }
            }
        }
        return this.host;
    }

    @NotNull
    public Metadata metadata() throws CassandraUnavailableException {
        return this.fromAdapter(ICassandraAdapter::metadata);
    }

    @NotNull
    public NodeSettings nodeSettings() throws CassandraUnavailableException {
        return this.nodeSettingsFromJmx;
    }

    @NotNull
    public ResultSet executeLocal(Statement statement) throws CassandraUnavailableException {
        return this.fromAdapter(adapter -> adapter.executeLocal(statement));
    }

    @NotNull
    public InetSocketAddress localNativeTransportAddress() throws CassandraUnavailableException {
        return this.fromAdapter(ICassandraAdapter::localNativeTransportAddress);
    }

    @NotNull
    public InetSocketAddress localStorageBroadcastAddress() throws CassandraUnavailableException {
        return this.fromAdapter(ICassandraAdapter::localStorageBroadcastAddress);
    }

    @NotNull
    public StorageOperations storageOperations() throws CassandraUnavailableException {
        return this.fromAdapter(ICassandraAdapter::storageOperations);
    }

    @NotNull
    public MetricsOperations metricsOperations() throws CassandraUnavailableException {
        return this.fromAdapter(ICassandraAdapter::metricsOperations);
    }

    @NotNull
    public ClusterMembershipOperations clusterMembershipOperations() throws CassandraUnavailableException {
        return this.fromAdapter(ICassandraAdapter::clusterMembershipOperations);
    }

    @NotNull
    public TableOperations tableOperations() throws CassandraUnavailableException {
        return this.fromAdapter(ICassandraAdapter::tableOperations);
    }

    public void onAdd(Host host) {
        LOGGER.debug("Host added. host={}", (Object)host);
        this.runIfThisHost(host, this::healthCheck);
    }

    public void onUp(Host host) {
        LOGGER.debug("Host up. host={}", (Object)host);
        this.runIfThisHost(host, this::healthCheck);
    }

    public void onDown(Host host) {
        LOGGER.debug("Host down. host={}", (Object)host);
        this.runIfThisHost(host, this::markNativeDownAndMaybeNotifyDisconnection);
    }

    public void onRemove(Host host) {
        LOGGER.debug("Host removed. host={}", (Object)host);
        this.runIfThisHost(host, this::healthCheck);
    }

    public void onRegister(Cluster cluster) {
    }

    public void onUnregister(Cluster cluster) {
    }

    public boolean isNativeUp() {
        return this.isNativeUp.get();
    }

    public boolean isJmxUp() {
        return this.nodeSettingsFromJmx != null;
    }

    public void close() {
        this.closed = true;
        this.markNativeDownAndMaybeNotifyDisconnection();
        this.markJmxDownAndMaybeNotifyDisconnection();
        Session activeSession = this.cqlSessionProvider.getIfConnected();
        if (activeSession != null) {
            this.maybeUnregisterHostListener(activeSession);
        }
        if (this.jmxClient != null) {
            this.jmxClient.unregisterListener((NotificationListener)this.notificationListener);
            try {
                this.jmxClient.close();
            }
            catch (IOException e) {
                LOGGER.warn("Unable to close JMX client", (Throwable)e);
            }
        }
    }

    public SimpleCassandraVersion version() {
        this.healthCheck();
        return this.currentVersion;
    }

    protected void notifyJmxConnection() {
        ((DefaultSettableGauge)this.healthMetrics.jmxDown.metric).setValue((Object)0);
        JsonObject connectMessage = new JsonObject().put("cassandraInstanceId", (Object)this.cassandraInstanceId);
        this.vertx.eventBus().publish(SidecarServerEvents.ON_CASSANDRA_JMX_READY.address(), (Object)connectMessage);
        LOGGER.info("JMX connected to cassandraInstanceId={}", (Object)this.cassandraInstanceId);
    }

    protected void notifyNativeConnection() {
        ((DefaultSettableGauge)this.healthMetrics.nativeDown.metric).setValue((Object)0);
        JsonObject connectMessage = new JsonObject().put("cassandraInstanceId", (Object)this.cassandraInstanceId);
        this.vertx.eventBus().publish(SidecarServerEvents.ON_CASSANDRA_CQL_READY.address(), (Object)connectMessage);
        LOGGER.info("CQL connected to cassandraInstanceId={}", (Object)this.cassandraInstanceId);
    }

    protected void markNativeDownAndMaybeNotifyDisconnection() {
        ((DefaultSettableGauge)this.healthMetrics.nativeDown.metric).setValue((Object)1);
        if (this.isNativeUp.compareAndSet(true, false)) {
            JsonObject disconnectMessage = new JsonObject().put("cassandraInstanceId", (Object)this.cassandraInstanceId);
            this.vertx.eventBus().publish(SidecarServerEvents.ON_CASSANDRA_CQL_DISCONNECTED.address(), (Object)disconnectMessage);
            LOGGER.info("CQL disconnection from cassandraInstanceId={}", (Object)this.cassandraInstanceId);
        }
    }

    protected void markJmxDownAndMaybeNotifyDisconnection() {
        ((DefaultSettableGauge)this.healthMetrics.jmxDown.metric).setValue((Object)1);
        NodeSettings currentNodeSettings = this.nodeSettingsFromJmx;
        this.nodeSettingsFromJmx = null;
        this.currentVersion = null;
        this.adapter = null;
        if (currentNodeSettings != null) {
            JsonObject disconnectMessage = new JsonObject().put("cassandraInstanceId", (Object)this.cassandraInstanceId);
            this.vertx.eventBus().publish(SidecarServerEvents.ON_CASSANDRA_JMX_DISCONNECTED.address(), (Object)disconnectMessage);
            LOGGER.info("JMX disconnection from cassandraInstanceId={}", (Object)this.cassandraInstanceId);
        }
    }

    @NotNull
    private <T> T fromAdapter(Function<ICassandraAdapter, T> getter) throws CassandraUnavailableException {
        ICassandraAdapter localAdapter = this.adapter;
        if (localAdapter == null) {
            throw new CassandraUnavailableException(CassandraUnavailableException.Service.CQL_AND_JMX, "CassandraAdapter is null");
        }
        return getter.apply(localAdapter);
    }

    private void runIfThisHost(Host host, Runnable runnable) {
        if (this.localNativeTransportAddress.equals(this.driverUtils.getSocketAddress(host))) {
            runnable.run();
        }
    }

    public static interface LimitedEndpointSnitchOperations {
        public String getDatacenter();
    }

    public static interface LimitedStorageOperations {
        public String getReleaseVersion();

        public String getPartitionerName();

        public List<String> getTokens();
    }

    protected class JmxNotificationListener
    implements NotificationListener {
        protected JmxNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification instanceof JMXConnectionNotification) {
                String type;
                JMXConnectionNotification connectNotice = (JMXConnectionNotification)notification;
                switch (type = connectNotice.getType()) {
                    case "jmx.remote.connection.opened": {
                        CassandraAdapterDelegate.this.jmxHealthCheck();
                        break;
                    }
                    case "jmx.remote.connection.closed": 
                    case "jmx.remote.connection.failed": 
                    case "jmx.remote.connection.notifs.lost": {
                        CassandraAdapterDelegate.this.markJmxDownAndMaybeNotifyDisconnection();
                        break;
                    }
                    default: {
                        LOGGER.warn("Encountered unexpected JMX notification type={}", (Object)type);
                    }
                }
            }
        }
    }
}

