/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authentication;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.CertificateCredentials;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.mtls.MutualTlsAuthentication;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;

public class MutualTlsAuthenticationHandler
extends AuthenticationHandlerImpl<MutualTlsAuthentication> {
    public MutualTlsAuthenticationHandler(MutualTlsAuthentication authProvider) {
        super((AuthenticationProvider)authProvider);
    }

    public void authenticate(RoutingContext ctx, Handler<AsyncResult<User>> handler) {
        if (!ctx.request().isSSL()) {
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end();
            return;
        }
        CertificateCredentials certificateCredentials = CertificateCredentials.fromHttpRequest((HttpServerRequest)ctx.request());
        ((MutualTlsAuthentication)this.authProvider).authenticate((Credentials)certificateCredentials).recover(cause -> {
            throw new HttpException(HttpResponseStatus.UNAUTHORIZED.code(), cause);
        }).andThen(handler);
    }
}

