/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authentication;

import io.vertx.ext.auth.authentication.CertificateCredentials;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.mtls.impl.SpiffeIdentityExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.IdentityToRoleCache;

public class CassandraIdentityExtractor
extends SpiffeIdentityExtractor {
    private final IdentityToRoleCache identityToRoleCache;
    private final Set<String> adminIdentities;

    public CassandraIdentityExtractor(IdentityToRoleCache identityToRoleCache, Set<String> adminIdentities) {
        this.identityToRoleCache = identityToRoleCache;
        this.adminIdentities = adminIdentities != null ? Collections.unmodifiableSet(adminIdentities) : Collections.emptySet();
    }

    public List<String> validIdentities(CertificateCredentials certificateCredentials) throws CredentialValidationException {
        List identities = super.validIdentities(certificateCredentials);
        ArrayList<String> allowedIdentities = new ArrayList<String>();
        for (String identity : identities) {
            if (!this.adminIdentities.contains(identity) && !this.identityToRoleCache.containsKey(identity)) continue;
            allowedIdentities.add(identity);
        }
        if (allowedIdentities.isEmpty()) {
            throw new CredentialValidationException("Could not extract valid identities from certificate");
        }
        return allowedIdentities;
    }
}

