/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.server.MainModule;
import org.apache.cassandra.sidecar.server.Server;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraSidecarDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraSidecarDaemon.class);
    @VisibleForTesting
    static Server runningApplication;

    public static void main(String[] args) {
        Server app;
        Path confPath = CassandraSidecarDaemon.determineConfigPath();
        runningApplication = app = (Server)Guice.createInjector((Module[])new Module[]{new MainModule(confPath)}).getInstance(Server.class);
        app.start().onSuccess(deploymentId -> Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (CassandraSidecarDaemon.close(app)) {
                LOGGER.info("Cassandra Sidecar stopped successfully");
            }
        }))).onFailure(throwable -> {
            LOGGER.error("Failed to start Sidecar", throwable);
            CassandraSidecarDaemon.close(app);
            System.exit(1);
        });
    }

    @VisibleForTesting
    static boolean close(Server app) {
        try {
            app.close().toCompletionStage().toCompletableFuture().get(1L, TimeUnit.MINUTES);
            return true;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to stop Sidecar in 1 minute", (Throwable)ex);
            return false;
        }
    }

    private static Path determineConfigPath() {
        Path confPath;
        String yamlConfigurationPath = System.getProperty("sidecar.config");
        if (yamlConfigurationPath != null) {
            try {
                confPath = Paths.get(new URI(yamlConfigurationPath));
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Invalid URI: " + yamlConfigurationPath, e);
            }
        } else {
            confPath = Paths.get("conf/sidecar.yaml", new String[0]);
        }
        return CassandraSidecarDaemon.ensurePathExists(confPath);
    }

    private static Path ensurePathExists(Path confPath) {
        if (!Files.exists(confPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Sidecar configuration file '%s' does not exist", confPath.toAbsolutePath()));
        }
        return confPath;
    }
}

