/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import java.util.function.Predicate;
import org.apache.cassandra.sidecar.exceptions.SidecarSchemaModificationException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchema {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean initialized = false;

    public synchronized boolean initialize(@NotNull Session session, @NotNull Predicate<AbstractSchema> shouldCreateSchema) {
        this.initialized = this.initialized || this.initializeInternal(session, shouldCreateSchema);
        return this.initialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected PreparedStatement prepare(PreparedStatement cached, Session session, String cqlLiteral) {
        return cached == null ? session.prepare(cqlLiteral).setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM) : cached;
    }

    protected boolean initializeInternal(@NotNull Session session, @NotNull Predicate<AbstractSchema> shouldCreateSchema) {
        block5: {
            if (!this.exists(session.getCluster().getMetadata())) {
                if (shouldCreateSchema.test(this)) {
                    try {
                        ResultSet res = session.execute(this.createSchemaStatement());
                        if (!res.getExecutionInfo().isSchemaInAgreement()) {
                            this.logger.warn("Schema is not yet in agreement.");
                            return false;
                        }
                        break block5;
                    }
                    catch (Exception exception) {
                        String schemaName = this.getClass().getSimpleName();
                        throw new SidecarSchemaModificationException("Failed to modify schema for " + schemaName, exception);
                    }
                }
                return false;
            }
        }
        this.prepareStatements(session);
        this.logger.debug("{} is initialized!", (Object)this.getClass().getSimpleName());
        return true;
    }

    protected abstract String keyspaceName();

    protected abstract void prepareStatements(@NotNull Session var1);

    protected abstract boolean exists(@NotNull Metadata var1);

    protected abstract String createSchemaStatement();
}

