/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server.cluster.locator;

import com.datastax.driver.core.DataType;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Partitioners;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Token;

public class TokenRange {
    public final Range<Token> range;

    public static List<TokenRange> from(com.datastax.driver.core.TokenRange dsTokenRange) {
        DataType tokenDataType = dsTokenRange.getStart().getType();
        if (tokenDataType == DataType.varint()) {
            return dsTokenRange.unwrap().stream().map(range -> {
                BigInteger start = (BigInteger)range.getStart().getValue();
                BigInteger end = (BigInteger)range.getEnd().getValue();
                if (end.compareTo(Partitioners.RANDOM.minimumToken().toBigInteger()) == 0) {
                    end = Partitioners.RANDOM.maximumToken().toBigInteger();
                }
                return new TokenRange(start, end);
            }).collect(Collectors.toList());
        }
        if (tokenDataType == DataType.bigint()) {
            return dsTokenRange.unwrap().stream().map(range -> {
                BigInteger start = BigInteger.valueOf((Long)range.getStart().getValue());
                BigInteger end = BigInteger.valueOf((Long)range.getEnd().getValue());
                if (end.compareTo(Partitioners.MURMUR3.minimumToken().toBigInteger()) == 0) {
                    end = Partitioners.MURMUR3.maximumToken().toBigInteger();
                }
                return new TokenRange(start, end);
            }).collect(Collectors.toList());
        }
        throw new IllegalArgumentException("Unsupported token type: " + tokenDataType + ". Only tokens of Murmur3Partitioner and RandomPartitioner are supported.");
    }

    public static SymmetricDiffResult symmetricDiff(Set<TokenRange> left, Set<TokenRange> right) {
        TreeRangeSet mergedLeft = TreeRangeSet.create();
        TreeRangeSet mergedRight = TreeRangeSet.create();
        left.forEach(arg_0 -> TokenRange.lambda$symmetricDiff$2((RangeSet)mergedLeft, arg_0));
        right.forEach(arg_0 -> TokenRange.lambda$symmetricDiff$3((RangeSet)mergedRight, arg_0));
        TreeRangeSet resultLeft = TreeRangeSet.create((RangeSet)mergedLeft);
        resultLeft.removeAll((RangeSet)mergedRight);
        TreeRangeSet resultRight = TreeRangeSet.create((RangeSet)mergedRight);
        resultRight.removeAll((RangeSet)mergedLeft);
        return new SymmetricDiffResult(resultLeft.asRanges(), resultRight.asRanges());
    }

    public TokenRange(long start, long end) {
        this(BigInteger.valueOf(start), BigInteger.valueOf(end));
    }

    public TokenRange(BigInteger start, BigInteger end) {
        this(Token.from(start), Token.from(end));
    }

    public TokenRange(Token start, Token end) {
        this.range = Range.openClosed((Comparable)start, (Comparable)end);
    }

    public Token start() {
        return (Token)this.range.lowerEndpoint();
    }

    public BigInteger startAsBigInt() {
        return ((Token)this.range.lowerEndpoint()).toBigInteger();
    }

    public Token end() {
        return (Token)this.range.upperEndpoint();
    }

    public BigInteger endAsBigInt() {
        return ((Token)this.range.upperEndpoint()).toBigInteger();
    }

    public boolean encloses(TokenRange other) {
        return this.range.encloses(other.range);
    }

    public boolean intersects(TokenRange other) {
        return ((Token)this.range.lowerEndpoint()).compareTo((Token)other.range.upperEndpoint()) < 0 && ((Token)other.range.lowerEndpoint()).compareTo((Token)this.range.upperEndpoint()) < 0;
    }

    public boolean connectsWith(TokenRange other) {
        return this.range.isConnected(other.range);
    }

    public TokenRange intersection(TokenRange other) {
        Range overlap = this.range.intersection(other.range);
        return new TokenRange((Token)overlap.lowerEndpoint(), (Token)overlap.upperEndpoint());
    }

    public boolean largerThan(TokenRange other) {
        return this.start().compareTo(other.end()) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenRange that = (TokenRange)o;
        return Objects.equals(this.range, that.range);
    }

    public int hashCode() {
        return this.range.hashCode();
    }

    public String toString() {
        return "TokenRange(" + ((Token)this.range.lowerEndpoint()).toBigInteger() + ", " + ((Token)this.range.upperEndpoint()).toBigInteger() + "]";
    }

    private static /* synthetic */ void lambda$symmetricDiff$3(RangeSet mergedRight, TokenRange r) {
        mergedRight.add(r.range);
    }

    private static /* synthetic */ void lambda$symmetricDiff$2(RangeSet mergedLeft, TokenRange r) {
        mergedLeft.add(r.range);
    }

    public static class SymmetricDiffResult {
        public final Set<TokenRange> onlyInLeft;
        public final Set<TokenRange> onlyInRight;

        private SymmetricDiffResult(Set<Range<Token>> onlyInLeft, Set<Range<Token>> onlyInRight) {
            this.onlyInLeft = SymmetricDiffResult.toUnmodifiableSet(onlyInLeft);
            this.onlyInRight = SymmetricDiffResult.toUnmodifiableSet(onlyInRight);
        }

        private static Set<TokenRange> toUnmodifiableSet(Set<Range<Token>> ranges) {
            return ranges.stream().map(r -> new TokenRange((Token)r.lowerEndpoint(), (Token)r.upperEndpoint())).collect(Collectors.toUnmodifiableSet());
        }
    }
}

