/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base.jmx;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.sidecar.adapters.base.exception.OperationUnavailableException;
import org.apache.cassandra.sidecar.adapters.base.jmx.StorageJmxOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipDependentStorageJmxOperations
implements StorageJmxOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(GossipDependentStorageJmxOperations.class);
    private final StorageJmxOperations delegate;

    public GossipDependentStorageJmxOperations(StorageJmxOperations delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate must be not-null");
        this.ensureGossipIsEnabled();
    }

    @Override
    public List<String> getLiveNodesWithPort() {
        return this.delegate.getLiveNodesWithPort();
    }

    @Override
    public List<String> getUnreachableNodesWithPort() {
        return this.delegate.getUnreachableNodesWithPort();
    }

    @Override
    public List<String> getJoiningNodesWithPort() {
        return this.delegate.getJoiningNodesWithPort();
    }

    @Override
    public List<String> getLeavingNodesWithPort() {
        return this.delegate.getLeavingNodesWithPort();
    }

    @Override
    public List<String> getMovingNodesWithPort() {
        return this.delegate.getMovingNodesWithPort();
    }

    @Override
    public Map<String, String> getLoadMapWithPort() {
        return this.delegate.getLoadMapWithPort();
    }

    @Override
    public Map<String, String> getTokenToEndpointWithPortMap() {
        return this.delegate.getTokenToEndpointWithPortMap();
    }

    @Override
    public Map<String, Float> effectiveOwnershipWithPort(String keyspace) throws IllegalStateException {
        return this.delegate.effectiveOwnershipWithPort(keyspace);
    }

    @Override
    public Map<String, Float> getOwnershipWithPort() {
        return this.delegate.getOwnershipWithPort();
    }

    @Override
    public Map<String, String> getEndpointWithPortToHostId() {
        return this.delegate.getEndpointWithPortToHostId();
    }

    @Override
    public void takeSnapshot(String tag, Map<String, String> options, String ... entities) throws IOException {
        this.delegate.takeSnapshot(tag, options, entities);
    }

    @Override
    public void clearSnapshot(String tag, String ... keyspaceNames) {
        this.delegate.clearSnapshot(tag, keyspaceNames);
    }

    @Override
    public Map<List<String>, List<String>> getRangeToEndpointWithPortMap(String keyspace) {
        return this.delegate.getRangeToEndpointWithPortMap(keyspace);
    }

    @Override
    public Map<List<String>, List<String>> getPendingRangeToEndpointWithPortMap(String keyspace) {
        return this.delegate.getPendingRangeToEndpointWithPortMap(keyspace);
    }

    @Override
    public boolean isGossipRunning() {
        return this.delegate.isGossipRunning();
    }

    @Override
    public String[] getAllDataFileLocations() {
        return this.delegate.getAllDataFileLocations();
    }

    @Override
    public int forceKeyspaceCleanup(int jobs, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        return this.delegate.forceKeyspaceCleanup(jobs, keyspaceName, tables);
    }

    @Override
    public String getOperationMode() {
        return this.delegate.getOperationMode();
    }

    public void ensureGossipIsEnabled() {
        if (this.delegate.isGossipRunning()) {
            return;
        }
        LOGGER.warn("Gossip is disabled and unavailable for the operation");
        throw new OperationUnavailableException("Gossip is required for the operation but it is disabled");
    }

    @Override
    public void decommission(boolean force) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.delegate.decommission(force);
    }

    @Override
    public String getClusterName() {
        return this.delegate.getClusterName();
    }
}

