/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.net.InetSocketAddress;
import org.apache.cassandra.sidecar.adapters.base.CassandraClusterMembershipOperations;
import org.apache.cassandra.sidecar.adapters.base.CassandraMetricsOperations;
import org.apache.cassandra.sidecar.adapters.base.CassandraStorageOperations;
import org.apache.cassandra.sidecar.adapters.base.CassandraTableOperations;
import org.apache.cassandra.sidecar.common.response.NodeSettings;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.ClusterMembershipOperations;
import org.apache.cassandra.sidecar.common.server.ICassandraAdapter;
import org.apache.cassandra.sidecar.common.server.JmxClient;
import org.apache.cassandra.sidecar.common.server.MetricsOperations;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.TableOperations;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.common.server.utils.DriverUtils;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.jetbrains.annotations.NotNull;

public class CassandraAdapter
implements ICassandraAdapter {
    protected final DnsResolver dnsResolver;
    protected final JmxClient jmxClient;
    protected final CQLSessionProvider cqlSessionProvider;
    protected final InetSocketAddress localNativeTransportAddress;
    protected final DriverUtils driverUtils;
    private volatile Host host;

    public CassandraAdapter(DnsResolver dnsResolver, JmxClient jmxClient, CQLSessionProvider cqlSessionProvider, InetSocketAddress localNativeTransportAddress, DriverUtils driverUtils) {
        this.dnsResolver = dnsResolver;
        this.jmxClient = jmxClient;
        this.cqlSessionProvider = cqlSessionProvider;
        this.localNativeTransportAddress = localNativeTransportAddress;
        this.driverUtils = driverUtils;
    }

    @NotNull
    public Metadata metadata() throws CassandraUnavailableException {
        return this.cqlSessionProvider.get().getCluster().getMetadata();
    }

    @NotNull
    public NodeSettings nodeSettings() {
        throw new UnsupportedOperationException("Node settings are not provided by this adapter");
    }

    @NotNull
    public ResultSet executeLocal(Statement statement) {
        Session activeSession = this.cqlSessionProvider.get();
        Metadata metadata = this.metadata();
        Host host = this.getHost(metadata);
        statement.setConsistencyLevel(ConsistencyLevel.ONE);
        statement.setHost(host);
        return activeSession.execute(statement);
    }

    @NotNull
    public InetSocketAddress localNativeTransportAddress() {
        return this.localNativeTransportAddress;
    }

    @NotNull
    public InetSocketAddress localStorageBroadcastAddress() {
        Metadata metadata = this.metadata();
        return this.getHost(metadata).getBroadcastSocketAddress();
    }

    @NotNull
    public StorageOperations storageOperations() {
        return new CassandraStorageOperations(this.jmxClient, this.dnsResolver);
    }

    @NotNull
    public MetricsOperations metricsOperations() {
        return new CassandraMetricsOperations(this.jmxClient, this.cqlSessionProvider);
    }

    @NotNull
    public ClusterMembershipOperations clusterMembershipOperations() {
        return new CassandraClusterMembershipOperations(this.jmxClient);
    }

    @NotNull
    public TableOperations tableOperations() {
        return new CassandraTableOperations(this.jmxClient);
    }

    public String toString() {
        return "CassandraAdapter@" + Integer.toHexString(this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Host getHost(Metadata metadata) {
        if (this.host != null) {
            return this.host;
        }
        CassandraAdapter cassandraAdapter = this;
        synchronized (cassandraAdapter) {
            if (this.host == null) {
                this.host = this.driverUtils.getHost(metadata, this.localNativeTransportAddress);
                if (this.host == null) {
                    throw new CassandraUnavailableException(CassandraUnavailableException.Service.CQL, "No Host available in Metadata for address: " + this.localNativeTransportAddress);
                }
            }
        }
        return this.host;
    }
}

