/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu;

import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.utils.GPUStatistics;

public class MMTSJGPUInstruction
extends GPUInstruction {
    private MMTSJ.MMTSJType _type = null;

    private MMTSJGPUInstruction(Operator op, CPOperand in1, MMTSJ.MMTSJType type, CPOperand out, String opcode, String istr) {
        super(op, in1, null, out, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.MMTSJ;
        this._type = type;
    }

    public static MMTSJGPUInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 3);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        MMTSJ.MMTSJType titype = MMTSJ.MMTSJType.valueOf(parts[3]);
        if (!opcode.equalsIgnoreCase("tsmm")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an MMTSJGPUInstruction: " + str);
        }
        return new MMTSJGPUInstruction(new Operator(true), in1, titype, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        int rlen;
        GPUStatistics.incrementNoOfExecutedGPUInst();
        MatrixObject mat = this.getMatrixInputForGPUInstruction(ec, this._input1.getName());
        boolean isLeftTransposed = this._type == MMTSJ.MMTSJType.LEFT;
        int clen = rlen = (int)(isLeftTransposed ? mat.getNumColumns() : mat.getNumRows());
        ec.setMetaData(this._output.getName(), rlen, clen);
        LibMatrixCUDA.matmultTSMM(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName(), isLeftTransposed);
        ec.releaseMatrixInputForGPUInstruction(this._input1.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }

    public MMTSJ.MMTSJType getMMTSJType() {
        return this._type;
    }
}

