/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMerge;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMergeLocalFile;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMergeLocalMemory;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptimizerRuleBased;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysds.runtime.meta.DataCharacteristics;

public class ResultMergeLocalAutomatic
extends ResultMerge {
    private static final long serialVersionUID = 1600893100602101732L;
    private ResultMerge _rm = null;

    public ResultMergeLocalAutomatic(MatrixObject out, MatrixObject[] in, String outputFilename, boolean accum) {
        super(out, in, outputFilename, accum);
    }

    @Override
    public MatrixObject executeSerialMerge() {
        long cols;
        Timing time = new Timing(true);
        DataCharacteristics dc = this._output.getDataCharacteristics();
        long rows = dc.getRows();
        this._rm = OptimizerRuleBased.isInMemoryResultMerge(rows, cols = dc.getCols(), OptimizerUtils.getLocalMemBudget()) ? new ResultMergeLocalMemory(this._output, this._inputs, this._outputFName, this._isAccum) : new ResultMergeLocalFile(this._output, this._inputs, this._outputFName, this._isAccum);
        MatrixObject ret = this._rm.executeSerialMerge();
        LOG.trace((Object)("Automatic result merge (" + this._rm.getClass().getName() + ") executed in " + time.stop() + "ms."));
        return ret;
    }

    @Override
    public MatrixObject executeParallelMerge(int par) {
        long cols;
        DataCharacteristics dc = this._output.getDataCharacteristics();
        long rows = dc.getRows();
        this._rm = OptimizerRuleBased.isInMemoryResultMerge((long)par * rows, cols = dc.getCols(), OptimizerUtils.getLocalMemBudget()) ? new ResultMergeLocalMemory(this._output, this._inputs, this._outputFName, this._isAccum) : new ResultMergeLocalFile(this._output, this._inputs, this._outputFName, this._isAccum);
        return this._rm.executeParallelMerge(par);
    }
}

