/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser.dml;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.FunctionDictionary;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.parser.ImportStatement;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.ParseException;
import org.apache.sysds.parser.ParserWrapper;
import org.apache.sysds.parser.Statement;
import org.apache.sysds.parser.dml.CustomErrorListener;
import org.apache.sysds.parser.dml.DmlLexer;
import org.apache.sysds.parser.dml.DmlParser;
import org.apache.sysds.parser.dml.DmlPreprocessor;
import org.apache.sysds.parser.dml.DmlSyntacticValidator;

public class DMLParserWrapper
extends ParserWrapper {
    private static final Log LOG = LogFactory.getLog((String)DMLScript.class.getName());

    @Override
    public DMLProgram parse(String fileName, String dmlScript, Map<String, String> argVals) {
        return this.doParse(fileName, dmlScript, null, argVals);
    }

    public DMLProgram doParse(String fileName, String dmlScript, String sourceNamespace, Map<String, String> argVals) {
        ANTLRInputStream in;
        DMLProgram dmlPgm = null;
        try {
            if (dmlScript == null) {
                dmlScript = DMLParserWrapper.readDMLScript(fileName, LOG);
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(dmlScript.getBytes());
            in = new ANTLRInputStream(stream);
        }
        catch (FileNotFoundException e) {
            throw new ParseException("Cannot find file/resource: " + fileName, e);
        }
        catch (IOException e) {
            throw new ParseException("Cannot open file: " + fileName, e);
        }
        catch (LanguageException e) {
            throw new ParseException(e.getMessage(), e);
        }
        DmlParser.ProgramrootContext ast = null;
        CustomErrorListener errorListener = new CustomErrorListener();
        try {
            DmlLexer lexer = new DmlLexer(in);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            DmlParser antlr4Parser = new DmlParser(tokens);
            boolean tryOptimizedParsing = false;
            if (tryOptimizedParsing) {
                ((ParserATNSimulator)antlr4Parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                antlr4Parser.removeErrorListeners();
                antlr4Parser.setErrorHandler(new BailErrorStrategy());
                try {
                    ast = antlr4Parser.programroot();
                }
                catch (ParseCancellationException ex) {
                    tokens.reset();
                    antlr4Parser.reset();
                    if (fileName != null) {
                        errorListener.setCurrentFileName(fileName);
                    } else {
                        errorListener.setCurrentFileName("MAIN_SCRIPT");
                    }
                    antlr4Parser.addErrorListener(errorListener);
                    antlr4Parser.setErrorHandler(new DefaultErrorStrategy());
                    ((ParserATNSimulator)antlr4Parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                    ast = antlr4Parser.programroot();
                }
            } else {
                antlr4Parser.removeErrorListeners();
                antlr4Parser.addErrorListener(errorListener);
                errorListener.setCurrentFileName(fileName);
                ast = antlr4Parser.programroot();
            }
        }
        catch (Exception e) {
            throw new ParseException("ERROR: Cannot parse the program:" + fileName, e);
        }
        DmlParser.ProgramrootContext tree = ast;
        ParseTreeWalker walker = new ParseTreeWalker();
        DmlPreprocessor prep = new DmlPreprocessor(errorListener);
        walker.walk(prep, tree);
        DmlSyntacticValidator validator = new DmlSyntacticValidator(errorListener, argVals, sourceNamespace, prep.getFunctionDefs());
        walker.walk(validator, tree);
        errorListener.unsetCurrentFileName();
        this.parseIssues = errorListener.getParseIssues();
        this.atLeastOneWarning = errorListener.isAtLeastOneWarning();
        this.atLeastOneError = errorListener.isAtLeastOneError();
        if (this.atLeastOneError) {
            throw new ParseException(this.parseIssues, dmlScript);
        }
        if (this.atLeastOneWarning) {
            LOG.warn((Object)CustomErrorListener.generateParseIssuesMessage(dmlScript, this.parseIssues));
        }
        dmlPgm = DMLParserWrapper.createDMLProgram(ast, validator, sourceNamespace);
        return dmlPgm;
    }

    private static DMLProgram createDMLProgram(DmlParser.ProgramrootContext ast, DmlSyntacticValidator validator, String sourceNamespace) {
        DMLProgram dmlPgm = new DMLProgram();
        String namespace = sourceNamespace != null && sourceNamespace.length() > 0 ? sourceNamespace : ".defaultNS";
        dmlPgm.getNamespaces().put(namespace, new FunctionDictionary());
        for (DmlParser.FunctionStatementContext fn : ast.functionBlocks) {
            FunctionStatementBlock functionStmtBlk = new FunctionStatementBlock();
            functionStmtBlk.addStatement(fn.info.stmt);
            try {
                dmlPgm.addFunctionStatementBlock(namespace, fn.info.functionName, functionStmtBlk);
            }
            catch (LanguageException e) {
                LOG.error((Object)("line: " + fn.start.getLine() + ":" + fn.start.getCharPositionInLine() + " error processing function " + fn.info.functionName));
                return null;
            }
        }
        FunctionDictionary<FunctionStatementBlock> fbuiltins = validator.getParsedBuiltinFunctions();
        if (!fbuiltins.getFunctions().isEmpty()) {
            dmlPgm.createNamespace(".builtinNS");
        }
        for (Map.Entry<String, FunctionStatementBlock> e : fbuiltins.getFunctions().entrySet()) {
            dmlPgm.addFunctionStatementBlock(".builtinNS", e.getKey(), e.getValue());
        }
        for (DmlParser.StatementContext stmtCtx : ast.blocks) {
            Statement current = stmtCtx.info.stmt;
            if (current == null) {
                LOG.error((Object)("line: " + stmtCtx.start.getLine() + ":" + stmtCtx.start.getCharPositionInLine() + " error processing statement"));
                return null;
            }
            if (current instanceof ImportStatement) {
                if (stmtCtx.info.namespaces != null) {
                    for (Map.Entry<String, FunctionDictionary<FunctionStatementBlock>> e : stmtCtx.info.namespaces.entrySet()) {
                        DMLParserWrapper.addFunctions(dmlPgm, e.getKey(), e.getValue());
                    }
                } else {
                    LOG.error((Object)("line: " + stmtCtx.start.getLine() + ":" + stmtCtx.start.getCharPositionInLine() + " error processing import"));
                    return null;
                }
            }
            dmlPgm.addStatementBlock(DMLParserWrapper.getStatementBlock(current));
        }
        dmlPgm.hoistFunctionCallsFromExpressions();
        dmlPgm.mergeStatementBlocks();
        return dmlPgm;
    }

    private static void addFunctions(DMLProgram dmlPgm, String namespace, FunctionDictionary<FunctionStatementBlock> dict) {
        if (dict != null) {
            if (dmlPgm.getNamespaces().containsKey(namespace)) {
                dmlPgm.getNamespaces().get(namespace).merge(dict);
            } else {
                dmlPgm.getNamespaces().put(namespace, dict);
            }
        }
    }
}

