/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.sample;

import java.util.HashMap;
import org.apache.sysds.runtime.compress.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;

public class GuaranteedErrorEstimator {
    private static int guaranteedErrorEstimator(int nRows, int sampleSize, ReaderColumnSelection sampleRowsReader) {
        HashMap<DblArray, Integer> valsCount = GuaranteedErrorEstimator.getValCounts(sampleRowsReader);
        int singltonValsCount = 0;
        int otherValsCount = 0;
        for (Integer c : valsCount.values()) {
            if (c == 1) {
                ++singltonValsCount;
                continue;
            }
            ++otherValsCount;
        }
        return (int)Math.round((double)otherValsCount + (double)singltonValsCount * Math.sqrt((double)nRows / (double)sampleSize));
    }

    private static HashMap<DblArray, Integer> getValCounts(ReaderColumnSelection sampleRowsReader) {
        HashMap<DblArray, Integer> valsCount = new HashMap<DblArray, Integer>();
        DblArray val = null;
        while (null != (val = sampleRowsReader.nextRow())) {
            Integer cnt = valsCount.get(val);
            if (cnt == null) {
                cnt = 0;
            }
            Integer n = cnt;
            Integer n2 = cnt = Integer.valueOf(cnt + 1);
            valsCount.put(new DblArray(val), cnt);
        }
        return valsCount;
    }
}

