/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;

public class PartialBlock
implements WritableComparable<PartialBlock> {
    private double value;
    private int row = -1;
    private int column = -1;

    public PartialBlock(int r, int c, double v) {
        this.set(r, c, v);
    }

    public PartialBlock() {
    }

    public void set(int r, int c, double v) {
        this.row = r;
        this.column = c;
        this.value = v;
    }

    public int getRowIndex() {
        return this.row;
    }

    public int getColumnIndex() {
        return this.column;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.row = in.readInt();
        this.column = in.readInt();
        this.value = in.readDouble();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.row);
        out.writeInt(this.column);
        out.writeDouble(this.value);
    }

    public String toString() {
        return "[" + this.row + ", " + this.column + "]:" + this.value;
    }

    @Override
    public int compareTo(PartialBlock that) {
        if (this.row != that.row) {
            return this.row - that.row;
        }
        if (this.column != that.column) {
            return this.column - that.column;
        }
        return Double.compare(this.value, that.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PartialBlock)) {
            return false;
        }
        PartialBlock that = (PartialBlock)o;
        return this.row == that.row && this.column == that.column && this.value == that.value;
    }

    public int hashCode() {
        throw new RuntimeException("hashCode() should never be called on instances of this class.");
    }
}

