/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;

public class MultipleOutputCommitter
extends FileOutputCommitter {
    private String[] outputs;

    public void setupJob(JobContext context) throws IOException {
        String[] loutputs;
        super.setupJob(context);
        JobConf conf = context.getJobConf();
        for (String dir : loutputs = MRJobConfiguration.getOutputs(conf)) {
            Path path = new Path(dir);
            FileSystem fs = path.getFileSystem(conf);
            if (fs.mkdirs(path)) continue;
            LOG.error("Mkdirs failed to create " + path.toString());
        }
    }

    public void cleanupJob(JobContext context) throws IOException {
        JobConf conf = context.getJobConf();
        Path outputPath = FileOutputFormat.getOutputPath(conf);
        if (outputPath != null) {
            FileSystem fs = outputPath.getFileSystem(conf);
            context.getProgressible().progress();
            if (fs.exists(outputPath)) {
                fs.delete(outputPath, true);
            }
        }
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        JobConf conf = context.getJobConf();
        TaskAttemptID attemptId = context.getTaskAttemptID();
        this.outputs = MRJobConfiguration.getOutputs(conf);
        Path taskOutPath = FileOutputFormat.getWorkOutputPath(conf);
        FileSystem fs = taskOutPath.getFileSystem(conf);
        if (!fs.exists(taskOutPath)) {
            throw new IOException("Task output path " + taskOutPath.toString() + "does not exist.");
        }
        context.getProgressible().progress();
        this.moveFinalTaskOutputs(context, fs, taskOutPath);
        if (!fs.delete(taskOutPath, true)) {
            LOG.debug("Failed to delete the temporary output directory of task: " + attemptId + " - " + taskOutPath);
        }
    }

    private void moveFinalTaskOutputs(TaskAttemptContext context, FileSystem fs, Path taskOutput) throws IOException {
        FileStatus[] files;
        context.getProgressible().progress();
        if (fs.getFileStatus(taskOutput).isDirectory() && (files = fs.listStatus(taskOutput)) != null) {
            for (FileStatus file : files) {
                if (file.isDirectory()) continue;
                this.moveFileToDestination(context, fs, file.getPath());
            }
        }
    }

    private void moveFileToDestination(TaskAttemptContext context, FileSystem fs, Path file) throws IOException {
        TaskAttemptID attemptId = context.getTaskAttemptID();
        String name = file.getName();
        int index = Integer.parseInt(name.substring(0, name.indexOf("-")));
        Path dest = new Path(this.outputs[index], name);
        if (!fs.rename(file, dest)) {
            if (!fs.delete(dest, true)) {
                throw new IOException("Failed to delete earlier output " + dest + " for rename of " + file + " in task " + attemptId);
            }
            if (!fs.rename(file, dest)) {
                throw new IOException("Failed to save output " + dest + " for rename of " + file + " in task: " + attemptId);
            }
        }
    }
}

